/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.beLogic;

import com.devdyna.synergy.utils.LevelUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public interface ItemProducer {
    public boolean dropWhenFail();

    default public ArrayList<ItemStack> unifyDrops(List<ItemStack> items) {
        ArrayList<ItemStack> newItems = new ArrayList<ItemStack>();
        for (int i = 0; i < items.size(); ++i) {
            boolean check = false;
            int index = -1;
            for (ItemStack itemStack : newItems) {
                if (itemStack.getItem() != items.get(i).getItem() || itemStack.getCount() >= 64) continue;
                index = newItems.indexOf(itemStack);
                check = true;
                break;
            }
            if (check) {
                newItems.set(index, new ItemStack((ItemLike)newItems.get(index).getItem(), newItems.get(index).getCount() + 1));
                continue;
            }
            newItems.add(items.get(i));
        }
        return newItems;
    }

    default public void exportItems(ItemStack item, List<Direction> blacklistedDirs, Level level, BlockPos pos, Map<Direction, BlockCapabilityCache<IItemHandler, Direction>> cache) {
        int totalDir = Direction.values().length;
        for (Direction dir : Direction.values()) {
            if (blacklistedDirs.contains(dir)) {
                --totalDir;
                continue;
            }
            BlockCapabilityCache cachedData = cache.get(dir);
            if (cachedData == null) {
                cachedData = BlockCapabilityCache.create((BlockCapability)Capabilities.ItemHandler.BLOCK, (ServerLevel)((ServerLevel)level), (BlockPos)pos.relative(dir), (Object)dir.getOpposite());
            }
            cache.put(dir, cachedData);
            IItemHandler cap = (IItemHandler)cachedData.getCapability();
            if (cap == null || !(cap instanceof IItemHandler)) {
                --totalDir;
                continue;
            }
            ItemStack items = ItemHandlerHelper.insertItemStacked((IItemHandler)cap, (ItemStack)item, (boolean)false);
            if (!item.is(items.getItem()) || item.getCount() != items.getCount() || items == new ItemStack((ItemLike)Items.AIR) || !this.dropWhenFail()) break;
            LevelUtil.popItemFromPos(level, pos.above(), item);
            level.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 0.75f);
            break;
        }
        if (totalDir <= 0 && this.dropWhenFail()) {
            LevelUtil.popItemFromPos(level, pos.above(), item);
        }
    }
}

