/*
 * Decompiled with CFR 0.152.
 */
package com.devdyna.synergy.api.beLogic;

import com.devdyna.synergy.api.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;

public interface AreaOfEffect {
    public int radius();

    public int height();

    public Range radiusLimit();

    public Range heightLimit();

    default public Map.Entry<BlockPos, BlockPos> getPoints(Level level, BlockPos baseBlock, Direction dir, boolean isUp) {
        BlockPos relPos = baseBlock.relative(dir);
        Direction upDown = isUp ? Direction.UP : Direction.DOWN;
        ArrayList<Direction> validDirs = this.getHorizontalDirections(dir);
        return Map.entry(relPos.relative(validDirs.get(0), this.radius()), relPos.relative(validDirs.get(1), this.radius()).relative(dir, this.radius() * 2).relative(upDown, this.height() - 1));
    }

    default public Map.Entry<BlockPos, BlockPos> getPoints(Level level, BlockPos baseBlock, Direction dir, boolean isUp, int height, int radius) {
        BlockPos relPos = baseBlock.relative(dir);
        Direction upDown = isUp ? Direction.UP : Direction.DOWN;
        ArrayList<Direction> validDirs = this.getHorizontalDirections(dir);
        return Map.entry(relPos.relative(validDirs.get(0), radius), relPos.relative(validDirs.get(1), radius).relative(dir, radius * 2).relative(upDown, height - 1));
    }

    default public ArrayList<Direction> getDirections(ArrayList<Direction> blacklist) {
        ArrayList directions = new ArrayList(Arrays.stream(Direction.values()).distinct().collect(Collectors.toList()));
        directions = directions.stream().filter(d -> !blacklist.contains(d)).collect(Collectors.toCollection(ArrayList::new));
        return directions;
    }

    default public ArrayList<Direction> getHorizontalDirections(Direction exclude) {
        return this.getDirections(new ArrayList<Direction>(List.of(Direction.UP, Direction.DOWN, exclude, exclude.getOpposite())));
    }

    default public BlockPos getStartPoint(Map.Entry<BlockPos, BlockPos> map) {
        return map.getKey();
    }

    default public BlockPos getEndPoint(Map.Entry<BlockPos, BlockPos> map) {
        return map.getValue();
    }

    default public BlockPos getCenter(Direction dir, BlockPos pos) {
        return pos.relative(dir).relative(dir, this.radius());
    }

    default public List<BlockPos> getAreaSelection(BlockPos start, BlockPos end) {
        ArrayList<BlockPos> slots = new ArrayList<BlockPos>();
        for (int y = Math.min(start.getY(), end.getY()); y <= Math.max(start.getY(), end.getY()); ++y) {
            for (int x2 = Math.min(start.getX(), end.getX()); x2 <= Math.max(start.getX(), end.getX()); ++x2) {
                for (int z = Math.min(start.getZ(), end.getZ()); z <= Math.max(start.getZ(), end.getZ()); ++z) {
                    slots.add(new BlockPos(x2, y, z));
                }
            }
        }
        return slots;
    }

    default public List<BlockPos> getAreaSelection(Level level, Direction dir, BlockPos baseBlock) {
        Map.Entry<BlockPos, BlockPos> points = this.getPoints(level, baseBlock, dir, true);
        return this.getAreaSelection(this.getStartPoint(points), this.getEndPoint(points));
    }
}

