/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpackscreateintegration.common;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.BackpackContext;
import net.p3pp3rf1y.sophisticatedbackpackscreateintegration.backpack.MountedSophisticatedBackpack;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.ContraptionHelper;
import net.p3pp3rf1y.sophisticatedcore.compat.create.MountedStorageBase;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public class MountedBackpackContext {
    private final int contraptionEntityId;
    private final BlockPos localPos;

    public MountedBackpackContext(int contraptionEntityId, BlockPos localPos) {
        this.contraptionEntityId = contraptionEntityId;
        this.localPos = localPos;
    }

    public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
        return Optional.empty();
    }

    public IStorageWrapper getBackpackWrapper(Player player) {
        Entity entity = player.level().getEntity(this.contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return NoopStorageWrapper.INSTANCE;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        MountedStorageBase itemStorage = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)contraptionEntity, (BlockPos)this.localPos);
        if (itemStorage == null) {
            return NoopStorageWrapper.INSTANCE;
        }
        return itemStorage.getStorageWrapper();
    }

    public MountedBackpackContext getSubBackpackContext(int subBackpackSlotIndex) {
        return new SubBackpack(this.contraptionEntityId, this.localPos, subBackpackSlotIndex);
    }

    public MountedBackpackContext getParentBackpackContext() {
        return this;
    }

    public int getContraptionEntityId() {
        return this.contraptionEntityId;
    }

    public BlockPos getLocalPos() {
        return this.localPos;
    }

    public void toBuffer(FriendlyByteBuf buffer) {
        this.getType().toBuffer(buffer);
        this.addToBuffer(buffer);
    }

    public void addToBuffer(FriendlyByteBuf buffer) {
        buffer.writeInt(this.contraptionEntityId);
        buffer.writeBlockPos(this.localPos);
    }

    public static MountedBackpackContext fromBuffer(FriendlyByteBuf buffer) {
        BackpackContext.ContextType type = BackpackContext.ContextType.fromBuffer((FriendlyByteBuf)buffer);
        if (type == BackpackContext.ContextType.ITEM_SUB_BACKPACK) {
            return SubBackpack.fromBuffer(buffer);
        }
        if (type == BackpackContext.ContextType.ITEM_BACKPACK) {
            return new MountedBackpackContext(buffer.readInt(), buffer.readBlockPos());
        }
        throw new IllegalArgumentException();
    }

    public BackpackContext.ContextType getType() {
        return BackpackContext.ContextType.ITEM_BACKPACK;
    }

    public Component getDisplayName(ServerPlayer player) {
        return this.getBackpackWrapper((Player)player).getDisplayName();
    }

    public void setBlockRenderDirty(Player player) {
        Entity entity = player.level().getEntity(this.contraptionEntityId);
        if (!(entity instanceof AbstractContraptionEntity)) {
            return;
        }
        AbstractContraptionEntity contraptionEntity = (AbstractContraptionEntity)entity;
        MountedStorageBase mountedStorage = ContraptionHelper.getMountedStorage((AbstractContraptionEntity)contraptionEntity, (BlockPos)this.localPos);
        if (mountedStorage instanceof MountedSophisticatedBackpack) {
            MountedSophisticatedBackpack mountedSophisticatedBackpack = (MountedSophisticatedBackpack)mountedStorage;
            mountedSophisticatedBackpack.setBlockRenderDirty();
        }
    }

    public static class SubBackpack
    extends MountedBackpackContext {
        private final int subBackpackSlotIndex;
        @Nullable
        private IStorageWrapper parentWrapper;

        public SubBackpack(int contraptionEntityId, BlockPos localPos, int subBackpackSlotIndex) {
            super(contraptionEntityId, localPos);
            this.subBackpackSlotIndex = subBackpackSlotIndex;
        }

        @Override
        public Optional<IStorageWrapper> getParentBackpackWrapper(Player player) {
            if (this.parentWrapper == null) {
                this.parentWrapper = super.getBackpackWrapper(player);
            }
            return Optional.of(this.parentWrapper);
        }

        @Override
        public IStorageWrapper getBackpackWrapper(Player player) {
            return (IStorageWrapper)this.getParentBackpackWrapper(player).map(parent -> {
                ItemStack stackInSlot = parent.getInventoryHandler().getStackInSlot(this.subBackpackSlotIndex);
                if (!(stackInSlot.getItem() instanceof BackpackItem)) {
                    return IBackpackWrapper.Noop.INSTANCE;
                }
                return BackpackWrapper.fromStack((ItemStack)stackInSlot);
            }).orElse((IBackpackWrapper)IBackpackWrapper.Noop.INSTANCE);
        }

        @Override
        public void addToBuffer(FriendlyByteBuf buffer) {
            super.addToBuffer(buffer);
            buffer.writeInt(this.subBackpackSlotIndex);
        }

        public static MountedBackpackContext fromBuffer(FriendlyByteBuf buffer) {
            return new SubBackpack(buffer.readInt(), buffer.readBlockPos(), buffer.readInt());
        }

        @Override
        public MountedBackpackContext getParentBackpackContext() {
            return new MountedBackpackContext(this.getContraptionEntityId(), this.getLocalPos());
        }

        @Override
        public BackpackContext.ContextType getType() {
            return BackpackContext.ContextType.ITEM_SUB_BACKPACK;
        }

        @Override
        public Component getDisplayName(ServerPlayer player) {
            return Component.literal((String)("... > " + super.getDisplayName(player).getString()));
        }
    }
}

