/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.recipe;

import info.u_team.useful_railroads.init.UsefulRailroadsBlocks;
import info.u_team.useful_railroads.init.UsefulRailroadsRecipeSerializers;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;

public class TeleportRailSpecialCraftingRecipe
extends CustomRecipe {
    public TeleportRailSpecialCraftingRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput input, Level level) {
        int count = 0;
        for (int i = 0; i < input.size(); ++i) {
            CompoundTag compound;
            ItemStack stack = input.getItem(i);
            CustomData component = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = compound = component == null ? null : component.getUnsafe();
            if (stack.getItem() == ((BlockItem)UsefulRailroadsBlocks.TELEPORT_RAIL.getItem()).asItem() && compound != null && compound.contains("location")) {
                ++count;
                continue;
            }
            if (stack.isEmpty()) continue;
            count = 0;
        }
        return count == 1;
    }

    public ItemStack assemble(CraftingInput input, HolderLookup.Provider registries) {
        for (int i = 0; i < input.size(); ++i) {
            CompoundTag compound;
            ItemStack stack = input.getItem(i);
            if (stack.isEmpty()) continue;
            ItemStack copy = stack.copy();
            CustomData component = (CustomData)copy.get(DataComponents.BLOCK_ENTITY_DATA);
            CompoundTag compoundTag = compound = component == null ? null : component.copyTag();
            if (component != null) {
                compound.remove("location");
                copy.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)compound));
                compound.remove("id");
                if (compound.isEmpty()) {
                    copy.remove(DataComponents.BLOCK_ENTITY_DATA);
                }
            }
            return copy;
        }
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)UsefulRailroadsRecipeSerializers.CRAFTING_SPECIAL_TELEPORT_RAIL_REMOVE_LOCATION.get();
    }
}

