/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;

public abstract class FuelRecipe
implements Recipe<SingleRecipeInput> {
    protected final Ingredient ingredient;
    protected final int fuel;
    protected final String group;

    public FuelRecipe(String group, Ingredient ingredient, int fuel) {
        this.group = group;
        this.ingredient = ingredient;
        this.fuel = fuel;
    }

    public String getGroup() {
        return this.group;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public NonNullList<Ingredient> getIngredients() {
        NonNullList ingredients = NonNullList.create();
        ingredients.add((Object)this.ingredient);
        return ingredients;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return this.ingredient.test(input.getItem(0));
    }

    public int getFuel() {
        return this.fuel;
    }

    public static class Serializer<T extends FuelRecipe>
    implements RecipeSerializer<T> {
        private final MapCodec<T> codec = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(recipe -> recipe.group), (App)Ingredient.CODEC_NONEMPTY.fieldOf("ingredient").forGetter(recipe -> recipe.ingredient), (App)Codec.INT.fieldOf("fuel").orElse((Object)0).forGetter(recipe -> recipe.fuel)).apply((Applicative)instance, factory::create));
        private final StreamCodec<RegistryFriendlyByteBuf, T> streamCodec = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, recipe -> recipe.group, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, recipe -> recipe.ingredient, (StreamCodec)ByteBufCodecs.VAR_INT, recipe -> recipe.fuel, factory::create);

        public Serializer(Factory<T> factory) {
        }

        public MapCodec<T> codec() {
            return this.codec;
        }

        public StreamCodec<RegistryFriendlyByteBuf, T> streamCodec() {
            return this.streamCodec;
        }

        public static interface Factory<T extends FuelRecipe> {
            public T create(String var1, Ingredient var2, int var3);
        }
    }
}

