/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.item;

import info.u_team.u_team_core.api.item.UItemExtension;
import info.u_team.u_team_core.util.MathUtil;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.util.Location;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TeleportRailBlockItem
extends BlockItem
implements UItemExtension {
    public TeleportRailBlockItem(Block block, Item.Properties builder) {
        super(block, builder.stacksTo(1).rarity(Rarity.EPIC));
    }

    public InteractionResult place(BlockPlaceContext context) {
        CompoundTag compound;
        CustomData component = (CustomData)context.getItemInHand().get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compoundTag = compound = component == null ? null : component.getUnsafe();
        if (compound != null && compound.contains("location")) {
            return super.place(context);
        }
        Player player = context.getPlayer();
        if (player != null && player.getCommandSenderWorld().isClientSide) {
            player.sendSystemMessage((Component)Component.translatable((String)"block.usefulrailroads.teleport_rail.missing_setup").withStyle(ChatFormatting.RED));
        }
        return InteractionResult.FAIL;
    }

    public boolean updateItemEntity(ItemStack stack, ItemEntity itemEntity) {
        CompoundTag compound;
        CustomData component = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compoundTag = compound = component == null ? null : component.getUnsafe();
        if (compound != null && compound.contains("location")) {
            return false;
        }
        Level world = itemEntity.getCommandSenderWorld();
        Vec3 itemEntityVector = itemEntity.position();
        if (world.isClientSide) {
            if (world.random.nextInt(10) == 0) {
                for (int i = 0; i < 5; ++i) {
                    world.addParticle((ParticleOptions)ParticleTypes.ENCHANT, true, itemEntityVector.x(), itemEntityVector.y() + 0.5, itemEntityVector.z(), MathUtil.randomNumberInRange((RandomSource)world.getRandom(), (double)-0.2, (double)0.2), MathUtil.randomNumberInRange((RandomSource)world.getRandom(), (double)0.1, (double)1.5), MathUtil.randomNumberInRange((RandomSource)world.getRandom(), (double)-0.2, (double)0.2));
                }
            }
        } else {
            int age = itemEntity.getAge();
            if (age < 100) {
                return false;
            }
            AABB aabb = new AABB(itemEntityVector.x() - 1.0, itemEntityVector.y() - 1.0, itemEntityVector.z() - 1.0, itemEntityVector.x() + 1.0, itemEntityVector.y() + 1.0, itemEntityVector.z() + 1.0);
            world.getEntities((Entity)itemEntity, aabb, ItemEntity.class::isInstance).stream().map(ItemEntity.class::cast).map(ItemEntity::getItem).filter(otherStack -> otherStack.getItem() == Items.ENDER_PEARL).findAny().ifPresent(otherStack -> {
                otherStack.shrink(1);
                stack.update(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY, old -> {
                    CompoundTag oldCompound = old.copyTag();
                    oldCompound.put("location", (Tag)new Location((ResourceKey<Level>)world.dimension(), itemEntity.blockPosition()).serializeNBT());
                    BlockEntity.addEntityType((CompoundTag)oldCompound, (BlockEntityType)((BlockEntityType)UsefulRailroadsBlockEntityTypes.TELEPORT_RAIL.get()));
                    return CustomData.of((CompoundTag)oldCompound);
                });
                System.out.println(stack.toString());
                ItemEntity newItemEntity = new ItemEntity(world, itemEntityVector.x(), itemEntityVector.y(), itemEntityVector.z(), stack);
                newItemEntity.setDefaultPickUpDelay();
                itemEntity.remove(Entity.RemovalReason.DISCARDED);
                world.addFreshEntity((Entity)newItemEntity);
                if (world instanceof ServerLevel) {
                    LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(world);
                    lightningbolt.moveTo(itemEntityVector);
                    lightningbolt.setVisualOnly(true);
                    world.addFreshEntity((Entity)lightningbolt);
                }
            });
        }
        return false;
    }
}

