/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import info.u_team.useful_railroads.util.TrackBuilderMode;
import java.util.List;
import java.util.Objects;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class TrackBuilderComponent {
    public static final Codec<TrackBuilderComponent> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Items.CODEC.fieldOf("items").forGetter(component -> component.items), (App)Codec.INT.orElse((Object)0).fieldOf("fuel").forGetter(component -> component.fuel), (App)TrackBuilderMode.CODEC.orElse((Object)TrackBuilderMode.MODE_NOAIR).fieldOf("mode").forGetter(component -> component.mode)).apply((Applicative)instance, TrackBuilderComponent::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, TrackBuilderComponent> STREAM_CODEC = StreamCodec.composite(Items.STREAM_CODEC, component -> component.items, (StreamCodec)ByteBufCodecs.VAR_INT, component -> component.fuel, TrackBuilderMode.STREAM_CODEC, component -> component.mode, TrackBuilderComponent::new);
    public static final TrackBuilderComponent EMPTY = new TrackBuilderComponent(Items.EMPTY, 0, TrackBuilderMode.MODE_NOAIR);
    private final Items items;
    private final int fuel;
    private final TrackBuilderMode mode;

    private TrackBuilderComponent(Items items, int fuel, TrackBuilderMode mode) {
        this.items = items;
        this.fuel = fuel;
        this.mode = mode;
    }

    public static TrackBuilderComponent of(List<ItemStack> rails, List<ItemStack> groundBlocks, List<ItemStack> tunnelBlocks, List<ItemStack> redstoneTorches, List<ItemStack> torches, int fuel, TrackBuilderMode mode) {
        Items items = new Items(ItemContainerContents.fromItems(rails), ItemContainerContents.fromItems(groundBlocks), ItemContainerContents.fromItems(tunnelBlocks), ItemContainerContents.fromItems(redstoneTorches), ItemContainerContents.fromItems(torches));
        return new TrackBuilderComponent(items, fuel, mode);
    }

    public int getFuel() {
        return this.fuel;
    }

    public TrackBuilderMode getMode() {
        return this.mode;
    }

    public ItemContainerContents getRails() {
        return this.items.rails;
    }

    public ItemContainerContents getGroundBlocks() {
        return this.items.groundBlocks;
    }

    public ItemContainerContents getTunnelBlocks() {
        return this.items.tunnelBlocks;
    }

    public ItemContainerContents getRedstoneTorches() {
        return this.items.redstoneTorches;
    }

    public ItemContainerContents getTorches() {
        return this.items.torches;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fuel, this.items, this.mode});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TrackBuilderComponent other = (TrackBuilderComponent)obj;
        return this.fuel == other.fuel && Objects.equals(this.items, other.items) && this.mode == other.mode;
    }

    private record Items(ItemContainerContents rails, ItemContainerContents groundBlocks, ItemContainerContents tunnelBlocks, ItemContainerContents redstoneTorches, ItemContainerContents torches) {
        private static final Codec<Items> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemContainerContents.CODEC.fieldOf("rails").forGetter(Items::rails), (App)ItemContainerContents.CODEC.fieldOf("ground_blocks").forGetter(Items::groundBlocks), (App)ItemContainerContents.CODEC.fieldOf("tunnel_blocks").forGetter(Items::tunnelBlocks), (App)ItemContainerContents.CODEC.fieldOf("redstone_torches").forGetter(Items::redstoneTorches), (App)ItemContainerContents.CODEC.fieldOf("torches").forGetter(Items::torches)).apply((Applicative)instance, Items::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, Items> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemContainerContents.STREAM_CODEC, Items::rails, (StreamCodec)ItemContainerContents.STREAM_CODEC, Items::groundBlocks, (StreamCodec)ItemContainerContents.STREAM_CODEC, Items::tunnelBlocks, (StreamCodec)ItemContainerContents.STREAM_CODEC, Items::redstoneTorches, (StreamCodec)ItemContainerContents.STREAM_CODEC, Items::torches, Items::new);
        private static final Items EMPTY = new Items(ItemContainerContents.EMPTY, ItemContainerContents.EMPTY, ItemContainerContents.EMPTY, ItemContainerContents.EMPTY, ItemContainerContents.EMPTY);
    }
}

