/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomBlockEntityPoweredRailBlock;
import info.u_team.useful_railroads.blockentity.TeleportRailBlockEntity;
import info.u_team.useful_railroads.init.UsefulRailroadsBlockEntityTypes;
import info.u_team.useful_railroads.item.TeleportRailBlockItem;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TeleportRailBlock
extends CustomBlockEntityPoweredRailBlock {
    public TeleportRailBlock() {
        super((Supplier<? extends BlockEntityType<?>>)UsefulRailroadsBlockEntityTypes.TELEPORT_RAIL);
    }

    @Override
    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new TeleportRailBlockItem((Block)this, blockItemProperties);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        return this.openMenu(level, pos, player, true);
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (level.isClientSide || !((Boolean)state.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            return;
        }
        this.getBlockEntity((BlockGetter)level, pos).map(TeleportRailBlockEntity.class::cast).ifPresent(tileEntity -> tileEntity.teleport(pos, cart));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && !player.isCreative()) {
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), this.getItemStack((BlockGetter)level, pos));
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        return this.getItemStack((BlockGetter)level, pos);
    }

    private ItemStack getItemStack(BlockGetter level, BlockPos pos) {
        ItemStack stack = new ItemStack((ItemLike)this);
        this.getBlockEntity(level, pos).map(TeleportRailBlockEntity.class::cast).ifPresent(blockEntity -> {
            CompoundTag compound = new CompoundTag();
            blockEntity.saveNBT(compound, (HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)this.blockEntityType.get()), (CompoundTag)compound);
        });
        return stack;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        CustomData data = (CustomData)stack.get(DataComponents.BLOCK_ENTITY_DATA);
        CompoundTag compound = data == null ? null : data.copyTag();
        boolean compoundExists = compound != null;
        String langKey = "container.usefulrailroads.teleport_rail.";
        MutableComponent seperatorTextComponent = Component.literal((String)": ");
        if (compoundExists && compound.contains("location")) {
            CompoundTag locationCompound = compound.getCompound("location");
            tooltip.add((Component)Component.translatable((String)"container.usefulrailroads.teleport_rail.dimension").append((Component)seperatorTextComponent).append((Component)Component.literal((String)locationCompound.getString("dimension")).withStyle(ChatFormatting.DARK_GREEN)));
            tooltip.add((Component)Component.translatable((String)"container.usefulrailroads.teleport_rail.x").append((Component)seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(locationCompound.getInt("x"))).withStyle(ChatFormatting.DARK_GREEN)));
            tooltip.add((Component)Component.translatable((String)"container.usefulrailroads.teleport_rail.y").append((Component)seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(locationCompound.getInt("y"))).withStyle(ChatFormatting.DARK_GREEN)));
            tooltip.add((Component)Component.translatable((String)"container.usefulrailroads.teleport_rail.z").append((Component)seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(locationCompound.getInt("z"))).withStyle(ChatFormatting.DARK_GREEN)));
        } else {
            tooltip.add((Component)Component.translatable((String)"block.usefulrailroads.teleport_rail.missing_setup").withStyle(ChatFormatting.RED));
            tooltip.add((Component)Component.translatable((String)"block.usefulrailroads.teleport_rail.how_to_setup").withStyle(ChatFormatting.GRAY));
        }
        if (compoundExists) {
            tooltip.add((Component)Component.translatable((String)"container.usefulrailroads.teleport_rail.fuel").append((Component)seperatorTextComponent).append((Component)Component.literal((String)Integer.toString(compound.getInt("fuel"))).withStyle(ChatFormatting.DARK_AQUA)));
        }
    }
}

