/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.useful_railroads.block.CustomPoweredRailBlock;
import info.u_team.useful_railroads.block.RailBlockCustomProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.material.Fluids;

public class DirectionRailBlock
extends CustomPoweredRailBlock {
    public static final BooleanProperty AXIS_DIRECTION = RailBlockCustomProperty.AXIS_DIRECTION;

    public DirectionRailBlock() {
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (!((Boolean)state.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            return;
        }
        RailShape shape = this.getRailDirection(state, (BlockGetter)level, pos, cart);
        boolean positiveAxis = (Boolean)state.getValue((Property)AXIS_DIRECTION);
        if (shape == RailShape.EAST_WEST) {
            cart.setDeltaMovement(positiveAxis ? 0.6 : -0.6, cart.getDeltaMovement().y(), cart.getDeltaMovement().z());
        } else if (shape == RailShape.NORTH_SOUTH) {
            cart.setDeltaMovement(cart.getDeltaMovement().x(), cart.getDeltaMovement().y(), positiveAxis ? 0.6 : -0.6);
        }
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected BlockState updateDir(final Level level, final BlockPos pos, BlockState updateState, boolean placing) {
        return level.isClientSide ? updateState : new RailState(this, level, pos, updateState){

            public RailState place(boolean powered, boolean placing, RailShape unused) {
                boolean hasRailNorth = this.hasNeighborRail(pos.north());
                boolean hasRailSouth = this.hasNeighborRail(pos.south());
                boolean hasRailWest = this.hasNeighborRail(pos.west());
                boolean hasRailEast = this.hasNeighborRail(pos.east());
                RailShape shape = null;
                if ((hasRailNorth || hasRailSouth) && !hasRailWest && !hasRailEast) {
                    shape = RailShape.NORTH_SOUTH;
                }
                if ((hasRailWest || hasRailEast) && !hasRailNorth && !hasRailSouth) {
                    shape = RailShape.EAST_WEST;
                }
                if (shape == null) {
                    shape = (RailShape)this.state.getValue((Property)PoweredRailBlock.SHAPE);
                }
                this.updateConnections(shape);
                this.state = (BlockState)this.state.setValue((Property)PoweredRailBlock.SHAPE, (Comparable)shape);
                if (placing || level.getBlockState(pos) != this.state) {
                    level.setBlock(pos, this.state, 3);
                    for (BlockPos connection : this.connections) {
                        RailState railstate = this.getRail(connection);
                        if (railstate == null) continue;
                        railstate.removeSoftConnections();
                        if (!railstate.canConnectTo((RailState)this)) continue;
                        railstate.connectTo((RailState)this);
                    }
                }
                return this;
            }
        }.place(level.hasNeighborSignal(pos), placing, null).getState();
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        boolean isWater = context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.getAxisDirection() == Direction.AxisDirection.POSITIVE))).setValue((Property)SHAPE, (Comparable)(direction.getAxis() == Direction.Axis.Z ? RailShape.NORTH_SOUTH : RailShape.EAST_WEST))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWater));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{AXIS_DIRECTION});
    }
}

