/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import info.u_team.u_team_core.api.block.BlockItemProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.Vec3;

public abstract class CustomPoweredRailBlock
extends PoweredRailBlock
implements BlockItemProvider {
    protected final BlockItem blockItem = this.createBlockItem(new Item.Properties());
    protected final double minSpeed = 0.01;

    public CustomPoweredRailBlock() {
        super(BlockBehaviour.Properties.of().noCollission().strength(0.7f).sound(SoundType.METAL), true);
    }

    protected BlockItem createBlockItem(Item.Properties blockItemProperties) {
        return new BlockItem((Block)this, blockItemProperties);
    }

    public BlockItem blockItem() {
        return this.blockItem;
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        this.moveAlongTrack(pos, state, cart);
    }

    protected void moveAlongTrack(BlockPos pos, BlockState state, AbstractMinecart cart) {
        BaseRailBlock railBlock = (BaseRailBlock)state.getBlock();
        RailShape railDirection = railBlock.getRailDirection(state, (BlockGetter)cart.level(), pos, cart);
        boolean powered = railBlock == this ? (Boolean)state.getValue((Property)PoweredRailBlock.POWERED) : false;
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.getDeltaMovement());
        if (currentSpeed < 0.01) {
            if (cart.shouldDoRailFunctions() && powered) {
                this.doPushOffWall(pos, cart, railDirection, cart.getDeltaMovement());
            }
            this.doPassengerPush(cart);
        } else if (cart.shouldDoRailFunctions()) {
            if (powered) {
                this.doPoweredMovement(pos, state, cart, railDirection);
            } else {
                this.doUnpoweredMovement(cart);
            }
        }
    }

    protected void doPassengerPush(AbstractMinecart cart) {
        Vec3 passengerMotion;
        double passengerDistanceSqr;
        Entity passenger;
        Entity entity = passenger = cart.getPassengers().isEmpty() ? null : (Entity)cart.getPassengers().get(0);
        if (passenger instanceof Player && (passengerDistanceSqr = CustomPoweredRailBlock.getPlaneSqrDistance(passengerMotion = passenger.getDeltaMovement())) > 1.0E-4) {
            cart.setDeltaMovement(cart.getDeltaMovement().add(passengerMotion.x * 0.1, 0.0, passengerMotion.z * 0.1));
        }
    }

    protected void doUnpoweredMovement(AbstractMinecart cart) {
        double currentSpeed = CustomPoweredRailBlock.getPlaneSqrtDistance(cart.getDeltaMovement());
        if (currentSpeed < 0.01) {
            cart.setDeltaMovement(Vec3.ZERO);
        } else {
            cart.setDeltaMovement(cart.getDeltaMovement().multiply(0.5, 0.0, 0.5));
        }
    }

    protected void doPoweredMovement(BlockPos pos, BlockState state, AbstractMinecart cart, RailShape railDirection) {
        this.controlSpeed(pos, state, cart);
    }

    protected void doPushOffWall(BlockPos pos, AbstractMinecart cart, RailShape railDirection, Vec3 cartMotion) {
        double xCartMotion = cartMotion.x;
        double zCartMotion = cartMotion.z;
        if (railDirection == RailShape.EAST_WEST) {
            if (CustomPoweredRailBlock.isNormalCube(cart.level(), pos.west())) {
                xCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.level(), pos.east())) {
                xCartMotion = -0.01;
            }
        } else if (railDirection == RailShape.NORTH_SOUTH) {
            if (CustomPoweredRailBlock.isNormalCube(cart.level(), pos.north())) {
                zCartMotion = 0.01;
            } else if (CustomPoweredRailBlock.isNormalCube(cart.level(), pos.south())) {
                zCartMotion = -0.01;
            }
        } else {
            return;
        }
        cart.setDeltaMovement(xCartMotion, cartMotion.y, zCartMotion);
    }

    protected void controlSpeed(BlockPos pos, BlockState state, AbstractMinecart cart) {
        Vec3 cartMotion = cart.getDeltaMovement();
        double cartDistance = CustomPoweredRailBlock.getPlaneSqrtDistance(cartMotion);
        cart.setDeltaMovement(cartMotion.add(cartMotion.x / cartDistance * 0.06, 0.0, cartMotion.z / cartDistance * 0.06));
    }

    protected void speedUpCart(AbstractMinecart cart, double accel, double speedClamp) {
        Vec3 motion = cart.getDeltaMovement();
        double speed = motion.length();
        double newSpeed = Mth.clamp((double)(speed + accel), (double)(-speedClamp), (double)speedClamp);
        this.setCartSpeed(cart, newSpeed, motion);
    }

    protected void setCartSpeed(AbstractMinecart cart, double speed) {
        this.setCartSpeed(cart, speed, cart.getDeltaMovement());
    }

    protected void setCartSpeed(AbstractMinecart cart, double speed, Vec3 direction) {
        Vec3 directionNormalised = direction.normalize();
        this.setCartSpeed(cart, directionNormalised.multiply(new Vec3(speed, speed, speed)));
    }

    protected void setCartSpeed(AbstractMinecart cart, double velX, double velY, double velZ) {
        this.setCartSpeed(cart, new Vec3(velX, velY, velZ));
    }

    protected void setCartSpeed(AbstractMinecart cart, Vec3 vel) {
        cart.setDeltaMovement(vel);
        cart.move(MoverType.SELF, vel);
    }

    private static boolean isNormalCube(Level level, BlockPos pos) {
        return level.getBlockState(pos).isRedstoneConductor((BlockGetter)level, pos);
    }

    private static double getPlaneSqrtDistance(Vec3 vec) {
        return Math.sqrt(CustomPoweredRailBlock.getPlaneSqrDistance(vec));
    }

    private static double getPlaneSqrDistance(Vec3 vec) {
        return vec.x * vec.x + vec.z * vec.z;
    }
}

