/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.hostilenetworks.item;

import dev.shadowsoffire.hostilenetworks.Hostile;
import dev.shadowsoffire.hostilenetworks.gui.DeepLearnerContainer;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.items.ComponentItemHandler;

public class DeepLearnerItem
extends Item {
    public DeepLearnerItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext ctx) {
        if (!ctx.getLevel().isClientSide) {
            DeepLearnerContainer.DeepLearnerSource src = DeepLearnerContainer.DeepLearnerSource.fromHand(ctx.getHand());
            ctx.getPlayer().openMenu((MenuProvider)new Provider(src), buf -> buf.writeByte(src.ordinal()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        DeepLearnerContainer.DeepLearnerSource src = DeepLearnerContainer.DeepLearnerSource.fromHand(hand);
        player.openMenu((MenuProvider)new Provider(src), buf -> buf.writeByte(src.ordinal()));
        return InteractionResultHolder.sidedSuccess((Object)player.getItemInHand(hand), (boolean)level.isClientSide);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.literal((String)"DL_INV_MARKER"));
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return oldStack.getItem() != newStack.getItem();
    }

    public static ComponentItemHandler getItemHandler(ItemStack stack) {
        return new ComponentItemHandler((MutableDataComponentHolder)stack, Hostile.Components.LEARNER_INV, 4);
    }

    public static class Provider
    implements MenuProvider {
        private final DeepLearnerContainer.DeepLearnerSource src;

        public Provider(DeepLearnerContainer.DeepLearnerSource src) {
            this.src = src;
        }

        public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
            return new DeepLearnerContainer(id, inv, this.src);
        }

        public Component getDisplayName() {
            return Component.translatable((String)"hostilenetworks.title.deep_learner");
        }
    }
}

