/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apothic_enchanting;

import dev.shadowsoffire.apothic_enchanting.ApothicEnchanting;
import dev.shadowsoffire.apothic_enchanting.PowerFunction;
import dev.shadowsoffire.placebo.config.Configuration;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.enchantment.Enchantment;

public record EnchantmentInfo(Holder<Enchantment> ench, int maxLevel, int maxLootLevel, int levelCap, PowerFunction maxPower, PowerFunction minPower) {
    public static final StreamCodec<RegistryFriendlyByteBuf, EnchantmentInfo> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.ENCHANTMENT), EnchantmentInfo::ench, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentInfo::maxLevel, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentInfo::maxLootLevel, (StreamCodec)ByteBufCodecs.VAR_INT, EnchantmentInfo::levelCap, PowerFunction.STREAM_CODEC, EnchantmentInfo::maxPower, PowerFunction.STREAM_CODEC, EnchantmentInfo::minPower, EnchantmentInfo::new);

    public int getMaxLevel() {
        return Math.min(ApothicEnchanting.ENCH_HARD_CAPS.getOrDefault((Object)this.ench.getKey(), 127), this.maxLevel);
    }

    public int getMaxLootLevel() {
        return Math.min(ApothicEnchanting.ENCH_HARD_CAPS.getOrDefault((Object)this.ench.getKey(), 127), this.maxLootLevel);
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public static EnchantmentInfo fallback(Holder<Enchantment> ench) {
        return new EnchantmentInfo(ench, ((Enchantment)ench.value()).getMaxLevel(), ((Enchantment)ench.value()).getMaxLevel(), -1, PowerFunction.DefaultMaxPowerFunction.INSTANCE, new PowerFunction.DefaultMinPowerFunction(ench));
    }

    public static EnchantmentInfo load(Holder<Enchantment> ench, Configuration cfg) {
        String category = ench.getKey().location().toString();
        int vanillaMax = ((Enchantment)ench.value()).definition().maxLevel();
        int max = cfg.getInt("Max Level", category, ApothicEnchanting.getDefaultMaxLevel(ench), 1, 127, "The max level of this enchantment - originally " + vanillaMax + ".");
        int maxLoot = cfg.getInt("Max Loot Level", category, vanillaMax, 1, 127, "The max level of this enchantment available from loot sources.");
        int levelCap = cfg.getInt("Forced Level Cap", category, -1, -1, 127, "The enforced effective max level of this enchantment. Regardless of NBT and other buffs, this enchantment will never exceed this level. -1 to disable.");
        if (levelCap != -1 && levelCap < max) {
            ApothicEnchanting.LOGGER.error("Invalid level cap of {} for enchantment \"{}\" will be ignored. The level cap must be greater than or equal to the configured max level ({}).", (Object)levelCap, (Object)category, (Object)max);
            levelCap = -1;
        }
        String maxF = cfg.getString("Max Power Function", category, "", "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
        String minF = cfg.getString("Min Power Function", category, "", "A function to determine the min enchanting power.");
        PowerFunction maxPower = maxF.isEmpty() ? PowerFunction.DefaultMaxPowerFunction.INSTANCE : new PowerFunction.ExpressionPowerFunction(maxF);
        PowerFunction minPower = minF.isEmpty() ? new PowerFunction.DefaultMinPowerFunction(ench) : new PowerFunction.ExpressionPowerFunction(minF);
        return new EnchantmentInfo(ench, max, maxLoot, levelCap, maxPower, minPower);
    }
}

