/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels.neoforge.mixin;

import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@Mixin(value={EnchantmentUtils.class})
public abstract class EnchantmentUtilsMixin {
    @Overwrite
    public static boolean chargeExperience(Player player, int xpCost) {
        if (xpCost < 0) {
            return false;
        }
        int levelCost = EnchantmentUtils.getLevelForExperience((int)xpCost);
        int xpCostRemainder = xpCost - EnchantmentUtils.getTotalExperienceForLevel((int)levelCost);
        int flattenedXpCost = TaxFreeLevels.getFlattenedXpCost(player, levelCost) + xpCostRemainder;
        if (EnchantmentUtils.getExperience((Player)player) < flattenedXpCost) {
            return false;
        }
        TaxFreeLevels.addNoScoreExperience(player, -flattenedXpCost);
        return true;
    }
}

