/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels;

import io.github.fourmisain.taxfreelevels.TaxFreeLevelsConfig;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TaxFreeLevels {
    public static final String MOD_ID = "taxfreelevels";
    public static final Logger LOGGER = LogManager.getLogger((String)"taxfreelevels");
    public static String CUSTOM_OPTIONS_FIELD = "taxfreelevels:options";
    private static final ThreadLocal<Integer> levelRequirement = ThreadLocal.withInitial(() -> -1);

    public static ResourceLocation id(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public static int getXpDifference(Player player, int from, int to) {
        int currentLevel = player.experienceLevel;
        int xpSum = 0;
        int l = from;
        while (l < to) {
            player.experienceLevel = l++;
            xpSum += player.getXpNeededForNextLevel();
        }
        player.experienceLevel = currentLevel;
        return xpSum;
    }

    public static void addNoScoreExperience(Player player, int xp) {
        player.experienceProgress += (float)xp / (float)player.getXpNeededForNextLevel();
        player.giveExperiencePoints(0);
        TaxFreeLevels.resetLevelRequirement();
    }

    public static void resetLevelRequirement() {
        levelRequirement.remove();
    }

    public static void setLevelRequirement(int value) {
        levelRequirement.set(value);
    }

    public static int getLevelRequirement() {
        return levelRequirement.get();
    }

    public static int getFlattenedXpCost(Player player, int levelCost) {
        int base = TaxFreeLevels.getLevelRequirement() >= 0 ? Math.max(TaxFreeLevels.getLevelRequirement(), TaxFreeLevelsConfig.get().levelBase) : TaxFreeLevelsConfig.get().levelBase;
        int pretendLevel = Math.min(player.experienceLevel, base);
        int from = Math.max(pretendLevel - levelCost, 0);
        return TaxFreeLevels.getXpDifference(player, from, from + levelCost);
    }

    public static void applyFlattenedXpCost(Player player, int levelCost) {
        TaxFreeLevels.addNoScoreExperience(player, -TaxFreeLevels.getFlattenedXpCost(player, levelCost));
    }
}

