/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.taxfreelevels;

import com.google.gson.JsonSyntaxException;
import io.github.fourmisain.taxfreelevels.TaxFreeLevels;
import io.github.fourmisain.taxfreelevels.TaxFreeLevelsConfig;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record ServerConfigPayload(TaxFreeLevelsConfig config) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<ServerConfigPayload> ID = new CustomPacketPayload.Type(TaxFreeLevels.id("server_config"));
    public static final StreamCodec<FriendlyByteBuf, ServerConfigPayload> CODEC = StreamCodec.ofMember((value, buf) -> {
        String json = TaxFreeLevelsConfig.GSON.toJson((Object)TaxFreeLevelsConfig.LOCAL_CONFIG.get());
        buf.writeUtf(json);
    }, buf -> {
        String json = buf.readUtf(Short.MAX_VALUE);
        try {
            TaxFreeLevelsConfig config = (TaxFreeLevelsConfig)TaxFreeLevelsConfig.GSON.fromJson(json, TaxFreeLevelsConfig.class);
            return new ServerConfigPayload(config);
        }
        catch (JsonSyntaxException e) {
            TaxFreeLevels.LOGGER.error("couldn't parse received config! \"{}\"", (Object)json, (Object)e);
            return null;
        }
    });

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

