/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.neoforge.client.event;

import cn.leolezury.eternalstarlight.common.client.handler.ESClientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="eternal_starlight", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    private static void onClientTick(ClientTickEvent.Post event) {
        ESClientHandler.onClientTick();
    }

    @SubscribeEvent
    private static void onComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        Vec3 angle = ESClientHandler.computeCameraAngles(new Vec3((double)event.getPitch(), (double)event.getYaw(), (double)event.getRoll()));
        event.setPitch((float)angle.x);
        event.setYaw((float)angle.y);
    }

    @SubscribeEvent
    private static void onComputeFovModifier(ComputeFovModifierEvent event) {
        ESClientHandler.modifyFov(event.getFovModifier()).ifPresent(d -> event.setNewFovModifier((float)d));
    }

    @SubscribeEvent
    private static void onRenderFog(ViewportEvent.RenderFog event) {
        ESClientHandler.onRenderFog(event.getCamera(), event.getMode());
    }

    @SubscribeEvent
    private static void onRenderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        if (ESClientHandler.renderBossBar(event.getGuiGraphics(), event.getBossEvent(), event.getX(), event.getY())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    private static void onRenderLevelStage(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ESClientHandler.onAfterRenderEntities((MultiBufferSource)event.getLevelRenderer().renderBuffers.bufferSource(), event.getPoseStack(), event.getPartialTick().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()));
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            ESClientHandler.onAfterRenderParticles();
        }
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_WEATHER) {
            ESClientHandler.onAfterRenderWeather(event.getPartialTick().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally()));
        }
    }
}

