/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.world.gen.feature.ESFeature;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.MergedProvider;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.RotatedProvider;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.SpikeProvider;
import cn.leolezury.eternalstarlight.common.world.gen.valuemap.ValueMapGenerator;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.phys.Vec3;

public class StarlightCrystalFeature
extends ESFeature<NoneFeatureConfiguration> {
    public StarlightCrystalFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos origin = context.origin();
        RandomSource random = context.random();
        boolean isRed = random.nextBoolean();
        BlockState crystalState = isRed ? ESBlocks.RED_STARLIGHT_CRYSTAL_BLOCK.get().defaultBlockState() : ESBlocks.BLUE_STARLIGHT_CRYSTAL_BLOCK.get().defaultBlockState();
        BlockState carpetState = isRed ? ESBlocks.RED_CRYSTAL_MOSS_CARPET.get().defaultBlockState() : ESBlocks.BLUE_CRYSTAL_MOSS_CARPET.get().defaultBlockState();
        BlockState clusterState = isRed ? ESBlocks.RED_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState() : ESBlocks.BLUE_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState();
        BlockState bloomingClusterState = isRed ? ESBlocks.BLOOMING_RED_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState() : ESBlocks.BLOOMING_BLUE_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState();
        BlockState flowerState = isRed ? ESBlocks.RED_CRYSTALFLEUR.get().defaultBlockState() : ESBlocks.BLUE_CRYSTALFLEUR.get().defaultBlockState();
        BlockState vineState = isRed ? ESBlocks.RED_CRYSTALFLEUR_VINE.get().defaultBlockState() : ESBlocks.BLUE_CRYSTALFLEUR_VINE.get().defaultBlockState();
        ArrayList<MergedProvider.Entry> entries = new ArrayList<MergedProvider.Entry>();
        int count = random.nextInt(3, 7);
        if (count == 4 && random.nextBoolean()) {
            count = 3;
        }
        for (int i = 0; i < count; ++i) {
            entries.add(new MergedProvider.Entry(new RotatedProvider(new SpikeProvider(1.5f + random.nextFloat(), 10.0f + random.nextFloat() * 3.0f), random.nextInt(40, 60), 360.0f / (float)count * (float)i), Vec3.ZERO));
        }
        entries.add(new MergedProvider.Entry(new SpikeProvider(2.0f + random.nextFloat(), 16.0f + random.nextFloat() * 5.0f), Vec3.ZERO));
        ValueMapGenerator.place(new MergedProvider(entries), (pos, value) -> this.setBlockIfEmpty(level, pos.offset((Vec3i)origin), crystalState));
        for (int x = -5; x <= 5; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    if (x * x + z * z >= 25) continue;
                    BlockPos placePos = origin.offset(x, y, z);
                    if (random.nextBoolean()) {
                        BlockPos belowPos;
                        if (random.nextInt(8) != 0) continue;
                        ArrayList<Direction> possibleDirs = new ArrayList<Direction>();
                        for (Direction direction2 : Direction.values()) {
                            BlockPos relativePos = placePos.relative(direction2);
                            if (!level.getBlockState(relativePos).is(crystalState.getBlock())) continue;
                            possibleDirs.add(direction2);
                        }
                        if (!possibleDirs.isEmpty()) {
                            if (random.nextInt(6) == 0) {
                                for (Direction direction2 : Direction.values()) {
                                    vineState = possibleDirs.contains(direction2) ? (BlockState)vineState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(random.nextBoolean())) : (BlockState)vineState.setValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction2), (Comparable)Boolean.valueOf(false));
                                }
                                BlockState finalVineState = vineState;
                                if (Arrays.stream(Direction.values()).anyMatch(direction -> (Boolean)finalVineState.getValue((Property)PipeBlock.PROPERTY_BY_DIRECTION.get(direction)))) {
                                    this.setBlockIfEmpty(level, placePos, finalVineState);
                                }
                            } else {
                                Direction direction3 = ((Direction)possibleDirs.get(random.nextInt(possibleDirs.size()))).getOpposite();
                                this.setBlockIfEmpty(level, placePos, (BlockState)(random.nextInt(3) == 0 ? bloomingClusterState : clusterState).setValue((Property)BlockStateProperties.FACING, (Comparable)direction3));
                            }
                        }
                        if (!level.getBlockState(belowPos = placePos.below()).isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) continue;
                        if (random.nextInt(12) == 0 && flowerState.canSurvive((LevelReader)level, placePos)) {
                            this.setBlockIfEmpty(level, placePos, random.nextBoolean() ? ESBlocks.RED_CRYSTALFLEUR.get().defaultBlockState() : ESBlocks.BLUE_CRYSTALFLEUR.get().defaultBlockState());
                            continue;
                        }
                        this.setBlockIfEmpty(level, placePos, random.nextBoolean() ? (random.nextInt(3) == 0 ? ESBlocks.BLOOMING_RED_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState() : ESBlocks.RED_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState()) : (random.nextInt(3) == 0 ? ESBlocks.BLOOMING_BLUE_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState() : ESBlocks.BLUE_STARLIGHT_CRYSTAL_CLUSTER.get().defaultBlockState()));
                        continue;
                    }
                    if (!level.getBlockState(placePos.below()).is(ESTags.Blocks.BASE_STONE_STARLIGHT)) continue;
                    this.setBlockIfEmpty(level, placePos, carpetState);
                }
            }
        }
        return true;
    }
}

