/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;

public class BlockPatchFeature
extends Feature<Configuration> {
    public BlockPatchFeature(Codec<Configuration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Configuration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        Configuration config = (Configuration)context.config();
        int size = config.size().sample(random);
        BlockPos.MutableBlockPos placePos = new BlockPos.MutableBlockPos();
        for (int x = -size; x <= size; ++x) {
            int y = (int)((float)(-size) / 1.8f);
            while ((float)y <= (float)size / 1.8f) {
                for (int z = -size; z <= size; ++z) {
                    if (!ESMathUtil.isPointInOrOnEllipsoid(x, y, z, size + random.nextInt(3) - 1, size + random.nextInt(3) - 1, size + random.nextInt(3) - 1)) continue;
                    placePos.setWithOffset((Vec3i)pos, x, y, z);
                    if (!level.getBlockState((BlockPos)placePos).is(config.replaceable())) continue;
                    this.setBlock((LevelWriter)level, (BlockPos)placePos, config.placeState().getState(random, (BlockPos)placePos));
                    level.getChunk((BlockPos)placePos).markPosForPostprocessing((BlockPos)placePos);
                }
                ++y;
            }
        }
        return true;
    }

    public record Configuration(BlockStateProvider placeState, TagKey<Block> replaceable, IntProvider size) implements FeatureConfiguration
    {
        public static final Codec<Configuration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("place_state").forGetter(Configuration::placeState), (App)TagKey.hashedCodec((ResourceKey)Registries.BLOCK).fieldOf("replaceable").forGetter(Configuration::replaceable), (App)IntProvider.CODEC.fieldOf("size").forGetter(Configuration::size)).apply((Applicative)instance, Configuration::new));
    }
}

