/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.client.ClientWeatherState;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TinyCreteor;
import cn.leolezury.eternalstarlight.common.entity.projectile.AethersentMeteor;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class MeteorShowerWeather
extends AbstractWeather {
    private static final Object2IntMap<ResourceKey<Level>> LAST_SUCCESSFUL_SPAWN = new Object2IntArrayMap();

    public MeteorShowerWeather(AbstractWeather.Properties properties) {
        super(properties);
    }

    @Override
    public boolean canStart(ServerLevel level) {
        return true;
    }

    @Override
    public boolean canContinue(ServerLevel level, int ticks) {
        return true;
    }

    @Override
    public void serverTick(ServerLevel level, int ticks) {
        if (!LAST_SUCCESSFUL_SPAWN.containsKey((Object)level.dimension()) || ticks - LAST_SUCCESSFUL_SPAWN.getInt((Object)level.dimension()) > 600) {
            for (ServerPlayer player : level.players()) {
                FluidState fluidState;
                BlockState blockState;
                if (player.isSpectator()) continue;
                BlockPos pos = player.blockPosition();
                DifficultyInstance difficulty = level.getCurrentDifficultyAt(pos);
                RandomSource random = level.getRandom();
                BlockPos randomPos = pos.above(20 + random.nextInt(15)).east(-10 + random.nextInt(21)).south(-10 + random.nextInt(21));
                if (!NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)level, (BlockPos)randomPos, (BlockState)(blockState = level.getBlockState(randomPos)), (FluidState)(fluidState = level.getFluidState(randomPos)), ESEntities.TINY_CRETEOR.get()) || randomPos.getY() <= level.getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, randomPos.getX(), randomPos.getZ())) continue;
                SpawnGroupData groupData = null;
                for (int i = 0; i < 2; ++i) {
                    TinyCreteor tinyCreteor = (TinyCreteor)ESEntities.TINY_CRETEOR.get().create((Level)level);
                    if (tinyCreteor == null) continue;
                    tinyCreteor.moveTo(randomPos, 0.0f, 0.0f);
                    groupData = tinyCreteor.finalizeSpawn((ServerLevelAccessor)level, difficulty, MobSpawnType.NATURAL, groupData);
                    level.addFreshEntityWithPassengers((Entity)tinyCreteor);
                    LAST_SUCCESSFUL_SPAWN.put((Object)level.dimension(), ticks);
                }
            }
        }
    }

    @Override
    public void tickBlock(ServerLevel level, int ticks, BlockPos pos) {
        if (level.getRandom().nextFloat() < ESConfig.INSTANCE.aethersentMeteorDropRate) {
            int targetX = pos.getX();
            int targetY = pos.getY();
            int targetZ = pos.getZ();
            RandomSource random = level.getRandom();
            AethersentMeteor meteor = new AethersentMeteor((Level)level, null, (double)targetX + ((double)random.nextFloat() - 0.5) * 3.0, (double)(targetY + 200) + ((double)random.nextFloat() - 0.5) * 5.0, (double)targetZ + ((double)random.nextFloat() - 0.5) * 3.0);
            meteor.setSize(10);
            meteor.setTargetPos(new Vec3((double)targetX, (double)targetY, (double)targetZ));
            level.addFreshEntity((Entity)meteor);
            level.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, meteor.getX(), meteor.getY(), meteor.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }

    @Override
    public void onStart(ServerLevel level) {
        LAST_SUCCESSFUL_SPAWN.removeInt((Object)level.dimension());
    }

    @Override
    public void onStop(ServerLevel level, int ticks) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick() {
        ClientLevel level = Minecraft.getInstance().level;
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        if (level != null && level.getGameTime() % 20L == 0L) {
            Vec3 randomPos = camera.getPosition().offsetRandom(level.getRandom(), 75.0f);
            int height = level.getHeight(Heightmap.Types.MOTION_BLOCKING, (int)randomPos.x, (int)randomPos.z);
            level.addParticle((ParticleOptions)ESParticles.METEOR.get(), true, randomPos.x, Math.max((double)(height + 75), camera.getPosition().y + 75.0), randomPos.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float modifyRainLevel(float original) {
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(Minecraft.getInstance().level != null && Minecraft.getInstance().level.tickRateManager().runsNormally());
        ClientWeatherState.levelTarget = 1.0f;
        return ClientWeatherState.getRainLevel(partialTick);
    }
}

