/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class ESEntityUtil {
    public static RaytraceResult raytrace(LevelAccessor level, CollisionContext context, Vec3 from, Vec3 to) {
        BlockHitResult hitResult = level.clip(new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, context));
        RaytraceResult result = new RaytraceResult(new ArrayList<Entity>(), (BlockHitResult)(hitResult.getType() == HitResult.Type.BLOCK ? hitResult : null));
        List entities = level.getEntitiesOfClass(Entity.class, new AABB(from, to).inflate(1.0));
        for (Entity entity : entities) {
            AABB aabb = entity.getBoundingBox().inflate((double)(entity.getPickRadius() + 0.5f));
            if (aabb.contains(from)) {
                result.entities().add(entity);
                continue;
            }
            if (!aabb.clip(from, to).isPresent()) continue;
            result.entities().add(entity);
        }
        result.entities().sort((o1, o2) -> (int)Math.signum(o1.position().distanceTo(from) - o2.position().distanceTo(from)));
        return result;
    }

    public static boolean shouldHarm(Entity attacker, Entity victim) {
        if (attacker == null || victim == null) {
            return true;
        }
        if (attacker == victim) {
            return false;
        }
        if (attacker.isAlliedTo(victim) || victim.isAlliedTo(attacker)) {
            return false;
        }
        if (attacker instanceof Player) {
            Player p2;
            Player p1 = (Player)attacker;
            if (victim instanceof Player && !p1.canHarmPlayer(p2 = (Player)victim)) {
                return false;
            }
        }
        return true;
    }

    public static VillagerTrades.ItemListing simpleTrade(Item cost, int costCount, Item result, int resultCount, int maxUses) {
        return ESEntityUtil.simpleTrade(new ItemStack((ItemLike)cost, costCount), new ItemStack((ItemLike)result, resultCount), maxUses);
    }

    public static VillagerTrades.ItemListing simpleTrade(ItemStack cost, ItemStack result, int maxUses) {
        return (entity, random) -> new MerchantOffer(new ItemCost((ItemLike)cost.getItem(), cost.getCount()), result, maxUses, 0, 0.0f);
    }

    public record RaytraceResult(List<Entity> entities, BlockHitResult blockHitResult) {
    }
}

