/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.network.UpdateBookPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.world.saved.BookProgressions;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ESBookUtil {
    public static BookProgressions getOrCreateBookProgressions(ServerLevel serverLevel) {
        return (BookProgressions)serverLevel.getDataStorage().computeIfAbsent(BookProgressions.factory(serverLevel), "book_progressions");
    }

    public static Set<ResourceLocation> getUnlockedParts(ServerPlayer player) {
        ServerLevel level;
        MinecraftServer server = player.getServer();
        if (server != null && (level = player.getServer().getLevel(Level.OVERWORLD)) != null) {
            BookProgressions progressions = ESBookUtil.getOrCreateBookProgressions(level);
            return progressions.getProgressions().getOrDefault(player.getUUID(), new HashSet());
        }
        return new HashSet<ResourceLocation>();
    }

    public static void unlock(ServerPlayer player, ResourceLocation ... locations) {
        ServerLevel level;
        MinecraftServer server = player.getServer();
        if (server != null && (level = player.getServer().getLevel(Level.OVERWORLD)) != null) {
            BookProgressions progressions = ESBookUtil.getOrCreateBookProgressions(level);
            Set<ResourceLocation> unlocked = ESBookUtil.getUnlockedParts(player);
            if (!unlocked.containsAll(Set.of(locations))) {
                HashSet<ResourceLocation> oldUnlocked = new HashSet<ResourceLocation>(unlocked);
                HashSet<ResourceLocation> newUnlocked = new HashSet<ResourceLocation>(unlocked);
                newUnlocked.addAll(Set.of(locations));
                progressions.getProgressions().put(player.getUUID(), newUnlocked);
                progressions.setDirty();
                List<String> listeningNamespaces = ESDataAttachments.GUIDEBOOK_LISTENING_NAMESPACES.getData((Entity)player);
                if (newUnlocked.stream().anyMatch(id -> !oldUnlocked.contains(id) && listeningNamespaces.contains(id.getNamespace()))) {
                    ESPlatform.INSTANCE.sendToClient(player, new UpdateBookPacket(oldUnlocked.stream().filter(id -> listeningNamespaces.contains(id.getNamespace())).collect(Collectors.toSet()), newUnlocked.stream().filter(id -> listeningNamespaces.contains(id.getNamespace())).collect(Collectors.toSet())));
                }
            }
        }
    }
}

