/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ESBlockUtil {
    public static boolean isEntityInBlock(Entity entity, Block block) {
        AABB box = entity.getBoundingBox();
        BlockPos fromPos = BlockPos.containing((double)(box.minX + 1.0E-7), (double)(box.minY + 1.0E-7), (double)(box.minZ + 1.0E-7));
        BlockPos toPos = BlockPos.containing((double)(box.maxX - 1.0E-7), (double)(box.maxY - 1.0E-7), (double)(box.maxZ - 1.0E-7));
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = fromPos.getX(); i <= toPos.getX(); ++i) {
            for (int j = fromPos.getY(); j <= toPos.getY(); ++j) {
                for (int k = fromPos.getZ(); k <= toPos.getZ(); ++k) {
                    mutableBlockPos.set(i, j, k);
                    BlockState blockState = entity.level().getBlockState((BlockPos)mutableBlockPos);
                    if (!blockState.is(block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static List<BlockPos> getBlocksInBoundingBox(AABB box) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        BlockPos fromPos = BlockPos.containing((double)(box.minX + 1.0E-7), (double)(box.minY + 1.0E-7), (double)(box.minZ + 1.0E-7));
        BlockPos toPos = BlockPos.containing((double)(box.maxX - 1.0E-7), (double)(box.maxY - 1.0E-7), (double)(box.maxZ - 1.0E-7));
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        for (int i = fromPos.getX(); i <= toPos.getX(); ++i) {
            for (int j = fromPos.getY(); j <= toPos.getY(); ++j) {
                for (int k = fromPos.getZ(); k <= toPos.getZ(); ++k) {
                    mutableBlockPos.set(i, j, k);
                    posList.add(mutableBlockPos.immutable());
                }
            }
        }
        return posList;
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, Direction direction) {
        return ESBlockUtil.rotateVoxelShape(shape, 0, 0, direction);
    }

    public static VoxelShape rotateVoxelShape(VoxelShape shape, int xRotOffset, int yRotOffset, Direction direction) {
        AtomicReference<VoxelShape> result = new AtomicReference<VoxelShape>(Shapes.empty());
        shape.forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            float rotX = (float)(direction == Direction.DOWN ? 180 : (direction == Direction.UP ? 0 : 90)) * ((float)Math.PI / 180) + (float)xRotOffset * ((float)Math.PI / 180);
            float rotY = (-direction.toYRot() + 180.0f) * ((float)Math.PI / 180) + (float)yRotOffset * ((float)Math.PI / 180);
            Vec3 min = new Vec3(minX - 0.5, minY - 0.5, minZ - 0.5);
            min = min.xRot(rotX).yRot(rotY);
            Vec3 max = new Vec3(maxX - 0.5, maxY - 0.5, maxZ - 0.5);
            max = max.xRot(rotX).yRot(rotY);
            result.set(Shapes.or((VoxelShape)((VoxelShape)result.get()), (VoxelShape)Shapes.create((double)(Math.min(min.x, max.x) + 0.5), (double)(Math.min(min.y, max.y) + 0.5), (double)(Math.min(min.z, max.z) + 0.5), (double)(Math.max(min.x, max.x) + 0.5), (double)(Math.max(min.y, max.y) + 0.5), (double)(Math.max(min.z, max.z) + 0.5))));
        });
        return result.get();
    }
}

