/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={LivingEntityRenderer.class})
public abstract class LivingEntityRendererMixin<T extends LivingEntity, M extends EntityModel<T>> {
    @Shadow
    public abstract M getModel();

    @Inject(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isSpectator()Z")})
    private void renderOverlay(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight, CallbackInfo ci) {
        if (entity instanceof AbstractClientPlayer && entity.level().getEntity(ESDataAttachments.HUSK_OWNER_ID.getData((Entity)entity).intValue()) instanceof Player) {
            AbstractClientPlayer player;
            VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)(entity instanceof AbstractClientPlayer && (player = (AbstractClientPlayer)entity).getSkin().model() == PlayerSkin.Model.SLIM ? EternalStarlight.id("textures/entity/tangled_husk_slim.png") : EternalStarlight.id("textures/entity/tangled_husk.png"))));
            this.getModel().renderToBuffer(poseStack, consumer, packedLight, LivingEntityRenderer.getOverlayCoords(entity, (float)0.0f));
        }
    }

    @WrapOperation(method={"render(Lnet/minecraft/world/entity/LivingEntity;FFLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/model/EntityModel;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;III)V")})
    private void renderToBuffer(M instance, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color, Operation<Void> original, @Local(ordinal=0, argsOnly=true) T entity) {
        if (entity instanceof AbstractClientPlayer && entity.level().getEntity(ESDataAttachments.HUSK_OWNER_ID.getData((Entity)entity).intValue()) instanceof Player) {
            int alpha = FastColor.ARGB32.alpha((int)color);
            int red = FastColor.ARGB32.red((int)color);
            int green = FastColor.ARGB32.green((int)color);
            int blue = FastColor.ARGB32.blue((int)color);
            original.call(new Object[]{instance, poseStack, vertexConsumer, packedLight, packedOverlay, FastColor.ARGB32.color((int)(alpha / 2), (int)(red / 2), (int)(green / 2), (int)blue)});
        } else {
            original.call(new Object[]{instance, poseStack, vertexConsumer, packedLight, packedOverlay, color});
        }
    }

    @Inject(method={"getRenderType(Lnet/minecraft/world/entity/LivingEntity;ZZZ)Lnet/minecraft/client/renderer/RenderType;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getRenderType(T livingEntity, boolean bodyVisible, boolean translucent, boolean glowing, CallbackInfoReturnable<RenderType> cir) {
        if (livingEntity instanceof AbstractClientPlayer && livingEntity.level().getEntity(ESDataAttachments.HUSK_OWNER_ID.getData((Entity)livingEntity).intValue()) instanceof Player && !translucent && bodyVisible) {
            cir.setReturnValue((Object)RenderType.entityTranslucent((ResourceLocation)((LivingEntityRenderer)this).getTextureLocation(livingEntity)));
        }
    }

    @Inject(method={"shouldShowName(Lnet/minecraft/world/entity/LivingEntity;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void shouldShowName(T livingEntity, CallbackInfoReturnable<Boolean> cir) {
        if (livingEntity.level().getEntity(ESDataAttachments.HUSK_OWNER_ID.getData((Entity)livingEntity).intValue()) instanceof Player) {
            cir.setReturnValue((Object)false);
        }
    }
}

