/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin.client;

import cn.leolezury.eternalstarlight.common.block.AlloyFurnaceBlock;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ClientLevel.class})
public abstract class ClientLevelMixin {
    @Shadow
    @Final
    private LevelRenderer levelRenderer;

    @Inject(method={"destroyBlockProgress(ILnet/minecraft/core/BlockPos;I)V"}, at={@At(value="RETURN")})
    private void destroyBlockProgress(int breakerId, BlockPos pos, int progress, CallbackInfo ci) {
        ClientLevel level = (ClientLevel)this;
        BlockState state = level.getBlockState(pos);
        if (state.getBlock() instanceof AlloyFurnaceBlock) {
            Direction facing = (Direction)state.getValue((Property)AlloyFurnaceBlock.FACING);
            int x = (Integer)state.getValue((Property)AlloyFurnaceBlock.X_OFFSET);
            int y = (Integer)state.getValue((Property)AlloyFurnaceBlock.Y_OFFSET);
            int z = (Integer)state.getValue((Property)AlloyFurnaceBlock.Z_OFFSET) - 1;
            if (x != 0 || y != 0 || z != 0) {
                Vec3 rotated = new Vec3((double)x, 0.0, (double)z).yRot((float)(((int)(-facing.toYRot()) + 90) % 360) * ((float)Math.PI / 180));
                int rotatedX = Math.round((float)rotated.x);
                int rotatedZ = Math.round((float)rotated.z);
                BlockPos centerPos = pos.offset(-rotatedX, -y, -rotatedZ);
                this.levelRenderer.destroyBlockProgress(breakerId, centerPos, progress);
            }
        }
    }
}

