/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.handler.ESCommonHandler;
import cn.leolezury.eternalstarlight.common.item.combat.DualWieldingSwordItem;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
implements SpellCaster {
    @Unique
    private boolean originalEnoughAttackStrength;

    @Shadow
    @NotNull
    public abstract ItemStack getWeaponItem();

    @Inject(method={"hurtCurrentlyUsedShield(F)V"}, at={@At(value="HEAD")})
    private void damageShield(float amount, CallbackInfo callBackInfo) {
        Player player = (Player)this;
        ItemStack useItem = player.getUseItem();
        if (useItem.is(ESTags.Items.GREATSWORDS)) {
            useItem.hurtAndBreak(Math.max((int)(amount / 5.0f), 1), (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
            player.stopUsingItem();
            player.getCooldowns().addCooldown(useItem.getItem(), 100);
        }
    }

    @Inject(method={"disableShield()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableShield(CallbackInfo ci) {
        Player player = (Player)this;
        ItemStack useItem = player.getUseItem();
        if (useItem.is(ESTags.Items.GREATSWORDS)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;hurtEnemy(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/player/Player;)Z")})
    private void attackHurtEnemy(Entity entity, CallbackInfo ci) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            ESCommonHandler.handleFlowglazeWeaponAttack((LivingEntity)((Player)this), living);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal=0)})
    private void attackCheckHammerStrength(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.HAMMERS)) {
            localRef.set(true);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F", opcode=180)})
    private void attackBeforeScytheSweepCheck(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.SCYTHES)) {
            this.originalEnoughAttackStrength = localRef.get();
            localRef.set(true);
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private void attackAfterScytheSweepCheck(Entity entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.getWeaponItem().is(ESTags.Items.SCYTHES)) {
            localRef.set(this.originalEnoughAttackStrength);
        }
    }

    @Inject(method={"aiStep()V"}, at={@At(value="TAIL")})
    private void aiStep(CallbackInfo ci) {
        Grappling grappling;
        Entity entity;
        Player player = (Player)this;
        if (!player.level().isClientSide && (entity = player.level().getEntity(ESDataAttachments.GRAPPLING.getData((Entity)player).intValue())) instanceof Grappling && (grappling = (Grappling)entity).reachedTarget() && grappling.shouldPull()) {
            player.resetFallDistance();
            if (!player.level().isClientSide) {
                float length = grappling.length();
                double d = entity.position().subtract(player.getEyePosition()).length();
                if (d > (double)length) {
                    double e = d / (double)length * 0.1;
                    boolean crouch = player.isCrouching();
                    player.addDeltaMovement(entity.position().subtract(player.getEyePosition()).scale(1.0 / d).multiply(e, e * 1.1, e).scale(crouch ? 0.6 : (player.onGround() ? 1.8 : 1.0)));
                    player.hurtMarked = true;
                }
            }
        }
    }

    @Inject(method={"getWeaponItem()Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getWeaponItem(CallbackInfoReturnable<ItemStack> cir) {
        Player player = (Player)this;
        if (ESDataAttachments.OFFHAND_ATTACK.getData((Entity)player).booleanValue()) {
            cir.setReturnValue((Object)player.getOffhandItem());
        }
    }

    @Inject(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getWeaponItem()Lnet/minecraft/world/item/ItemStack;")})
    private void beforeAttack(Entity entity, CallbackInfo ci) {
        ItemStack offhand;
        Player player = (Player)this;
        ItemStack mainHand = player.getMainHandItem();
        if (ItemStack.isSameItem((ItemStack)mainHand, (ItemStack)(offhand = player.getOffhandItem())) && mainHand.getItem() instanceof DualWieldingSwordItem) {
            entity.invulnerableTime = 0;
        }
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private ItemStack useOffhandWeapon(Player instance, InteractionHand hand, Operation<ItemStack> original) {
        if (hand == InteractionHand.MAIN_HAND && ESDataAttachments.OFFHAND_ATTACK.getData((Entity)instance).booleanValue()) {
            return (ItemStack)original.call(new Object[]{instance, InteractionHand.OFF_HAND});
        }
        return (ItemStack)original.call(new Object[]{instance, hand});
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getAttackStrengthScale(F)F")})
    private float useOffhandAttackStrengthTimer(Player instance, float f, Operation<Float> original) {
        if (ESDataAttachments.OFFHAND_ATTACK.getData((Entity)instance).booleanValue()) {
            return Mth.clamp((float)(((float)ESDataAttachments.OFFHAND_ATTACK_STRENGTH_TIMER.getData((Entity)instance).intValue() + f) / instance.getCurrentItemAttackStrengthDelay()), (float)0.0f, (float)1.0f);
        }
        return ((Float)original.call(new Object[]{instance, Float.valueOf(f)})).floatValue();
    }

    @WrapOperation(method={"attack(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;resetAttackStrengthTicker()V")})
    private void resetOffhandAttackStrengthTimer(Player instance, Operation<Void> original) {
        if (ESDataAttachments.OFFHAND_ATTACK.getData((Entity)instance).booleanValue()) {
            ESDataAttachments.OFFHAND_ATTACK_STRENGTH_TIMER.setData((Entity)instance, 0);
        } else {
            original.call(new Object[]{instance});
        }
    }

    @Inject(method={"isModelPartShown(Lnet/minecraft/world/entity/player/PlayerModelPart;)Z"}, at={@At(value="RETURN")}, cancellable=true)
    private void isModelPartShown(PlayerModelPart part, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        Entity entity = player.level().getEntity(ESDataAttachments.HUSK_OWNER_ID.getData((Entity)player).intValue());
        if (entity instanceof Player) {
            Player huskOwner = (Player)entity;
            cir.setReturnValue((Object)huskOwner.isModelPartShown(part));
        }
    }
}

