/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.block.flammable.ESFlammabilityRegistry;
import java.util.Optional;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={FireBlock.class})
public abstract class FireBlockMixin {
    @Inject(method={"getBurnOdds(Lnet/minecraft/world/level/block/state/BlockState;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getBurnOdds(BlockState blockState, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        Optional<ESFlammabilityRegistry.Flammability> flammability = ESFlammabilityRegistry.getBlockFlammability(blockState.getBlock());
        flammability.ifPresent(value -> callbackInfoReturnable.setReturnValue((Object)(blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? 0 : value.burnOdds())));
    }

    @Inject(method={"getIgniteOdds*(Lnet/minecraft/world/level/block/state/BlockState;)I"}, at={@At(value="HEAD")}, cancellable=true)
    private void getIgniteOdds(BlockState blockState, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        Optional<ESFlammabilityRegistry.Flammability> flammability = ESFlammabilityRegistry.getBlockFlammability(blockState.getBlock());
        flammability.ifPresent(value -> callbackInfoReturnable.setReturnValue((Object)(blockState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && (Boolean)blockState.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? 0 : value.catchOdds())));
    }
}

