/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.recipe;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESRecipeSerializers;
import cn.leolezury.eternalstarlight.common.registry.ESRecipes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public record AlloyRecipe(NonNullList<Result> results, NonNullList<Ingredient> ingredients, int burnTime) implements Recipe<CraftingInput>
{
    public RecipeSerializer<?> getSerializer() {
        return ESRecipeSerializers.ALLOY.get();
    }

    public RecipeType<?> getType() {
        return ESRecipes.ALLOY.get();
    }

    public ItemStack getToastSymbol() {
        return ESItems.ALLOY_FURNACE.get().getDefaultInstance();
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ((Result)this.results.getFirst()).item();
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (craftingInput.ingredientCount() != this.ingredients.size()) {
            return false;
        }
        return craftingInput.size() == 1 && this.ingredients.size() == 1 ? ((Ingredient)this.ingredients.getFirst()).test(craftingInput.getItem(0)) : craftingInput.stackedContents().canCraft((Recipe)this, null);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider provider) {
        return ((Result)this.results.getFirst()).item().copy();
    }

    public boolean canCraftInDimensions(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public record Result(ItemStack item, IntProvider amount) {
        public static final Codec<Result> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("item").forGetter(Result::item), (App)IntProvider.NON_NEGATIVE_CODEC.fieldOf("amount").forGetter(Result::amount)).apply((Applicative)instance, Result::new));
        public static final StreamCodec<? super RegistryFriendlyByteBuf, Result> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, Result::item, (StreamCodec)ByteBufCodecs.fromCodec((Codec)IntProvider.NON_NEGATIVE_CODEC), Result::amount, Result::new);

        public ItemStack getResultItem(RandomSource random) {
            return this.item().copyWithCount(this.amount().sample(random));
        }

        public ItemStack getMaxResultItem() {
            return this.item().copyWithCount(this.amount().getMaxValue());
        }

        public List<ItemStack> getAllPossibleResultItems() {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (int i = this.amount().getMinValue(); i <= this.amount().getMaxValue(); ++i) {
                results.add(this.item().copyWithCount(i));
            }
            return results;
        }
    }

    public static class Serializer
    implements RecipeSerializer<AlloyRecipe> {
        private static final MapCodec<AlloyRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Result.CODEC.listOf().fieldOf("results").flatXmap(list -> {
            Object[] items = (Result[])list.stream().filter(stack -> !stack.item().isEmpty()).toArray(Result[]::new);
            if (items.length == 0) {
                return DataResult.error(() -> "No result for alloy recipe");
            }
            return items.length > 3 ? DataResult.error(() -> "Too many results for alloy recipe") : DataResult.success((Object)NonNullList.of((Object)new Result(ItemStack.EMPTY, (IntProvider)ConstantInt.of((int)0)), (Object[])items));
        }, DataResult::success).forGetter(AlloyRecipe::results), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            if (ingredients.length == 0) {
                return DataResult.error(() -> "No ingredient for alloy recipe");
            }
            return ingredients.length > 9 ? DataResult.error(() -> "Too many ingredients for alloy recipe") : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(AlloyRecipe::ingredients), (App)Codec.INT.fieldOf("burn_time").forGetter(AlloyRecipe::burnTime)).apply((Applicative)instance, AlloyRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, AlloyRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<AlloyRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, AlloyRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static AlloyRecipe fromNetwork(RegistryFriendlyByteBuf byteBuf) {
            int resultSize = byteBuf.readVarInt();
            NonNullList results = NonNullList.withSize((int)resultSize, (Object)new Result(ItemStack.EMPTY, (IntProvider)ConstantInt.of((int)1)));
            results.replaceAll(result -> (Result)Result.STREAM_CODEC.decode((Object)byteBuf));
            int ingredientSize = byteBuf.readVarInt();
            NonNullList ingredients = NonNullList.withSize((int)ingredientSize, (Object)Ingredient.EMPTY);
            ingredients.replaceAll(ingredient -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)byteBuf));
            int burnTime = byteBuf.readInt();
            return new AlloyRecipe((NonNullList<Result>)results, (NonNullList<Ingredient>)ingredients, burnTime);
        }

        private static void toNetwork(RegistryFriendlyByteBuf byteBuf, AlloyRecipe alloyRecipe) {
            byteBuf.writeVarInt(alloyRecipe.results.size());
            for (Result result : alloyRecipe.results) {
                Result.STREAM_CODEC.encode((Object)byteBuf, (Object)result);
            }
            byteBuf.writeVarInt(alloyRecipe.ingredients.size());
            for (Ingredient ingredient : alloyRecipe.ingredients) {
                Ingredient.CONTENTS_STREAM_CODEC.encode((Object)byteBuf, (Object)ingredient);
            }
            byteBuf.writeInt(alloyRecipe.burnTime);
        }
    }

    public static class Type
    implements RecipeType<AlloyRecipe> {
        public static final ResourceLocation ID = EternalStarlight.id("alloy");

        public String toString() {
            return ID.toString();
        }
    }
}

