/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.attack.Whip;
import cn.leolezury.eternalstarlight.common.item.interfaces.Swingable;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public abstract class WhipItem
extends Item
implements Swingable {
    public WhipItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && !level.isClientSide && !(level.getEntity(ESDataAttachments.WHIP.getData((Entity)player).intValue()) instanceof Whip)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.addFreshEntity((Entity)this.createWhip(level, player, stack));
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return hand == InteractionHand.MAIN_HAND ? InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide) : InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public void swing(ItemStack stack, LivingEntity entity, InteractionHand hand) {
        Player player;
        Level level = entity.level();
        if (hand == InteractionHand.MAIN_HAND && !level.isClientSide && entity instanceof Player && !(level.getEntity(ESDataAttachments.WHIP.getData((Entity)(player = (Player)entity)).intValue()) instanceof Whip)) {
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.addFreshEntity((Entity)this.createWhip(level, player, stack));
        }
    }

    public abstract Whip createWhip(Level var1, Player var2, ItemStack var3);

    public int getEnchantmentValue() {
        return 1;
    }
}

