/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.attack.TangledHusk;
import cn.leolezury.eternalstarlight.common.item.combat.MoonringBowItem;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class WandOfTeleportationItem
extends Item {
    public WandOfTeleportationItem(Item.Properties properties) {
        super(properties);
    }

    private void createThornCircle(Level level, Player player, Vec3 target) {
        for (int i = 0; i < 7; ++i) {
            float radius = (float)(i + 1) * player.getBbWidth() * 0.75f;
            int num = 5;
            float startAngle = (float)i * 0.3f * (float)Math.PI;
            for (int j = 0; j < num; ++j) {
                float angle = startAngle + (float)Math.PI * 2 / (float)num * (float)j;
                MoonringBowItem.createThorn(level, (LivingEntity)player, target.x() + Math.cos(angle) * (double)radius, target.y(), target.z() + Math.sin(angle) * (double)radius, Mth.wrapDegrees((float)(-angle * 57.295776f)), 40.0, i * 3);
            }
        }
    }

    private void teleportPlayer(Level level, Player player, ItemStack stack, Vec3 target) {
        this.createThornCircle(level, player, player.position());
        TangledHusk husk = (TangledHusk)ESEntities.TANGLED_HUSK.get().create(level);
        if (husk != null) {
            husk.moveTo(player.position());
            husk.setYRot(player.getYRot());
            husk.yRotO = husk.getYRot();
            husk.setOwner((LivingEntity)player);
            level.addFreshEntity((Entity)husk);
        }
        if (ESPlatform.INSTANCE.postTeleportEvent((Entity)player, target)) {
            player.teleportTo(target.x, target.y, target.z);
            this.createThornCircle(level, player, target);
        }
        stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
        player.getCooldowns().addCooldown((Item)this, 600);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        Vec3 startPos = player.getEyePosition();
        float lookYaw = player.getYHeadRot() + 90.0f;
        float lookPitch = -player.getXRot();
        Vec3 endPos = ESMathUtil.rotationToPosition(startPos, 64.0f, lookPitch, lookYaw);
        ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((LevelAccessor)player.level(), CollisionContext.of((Entity)player), startPos, endPos);
        if (!result.entities().isEmpty()) {
            for (int i = 0; i < result.entities().size(); ++i) {
                if (result.entities().get(i) == player) continue;
                Vec3 target = result.entities().get(i).position();
                this.teleportPlayer(level, player, stack, target);
                player.awardStat(Stats.ITEM_USED.get((Object)this));
                return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
            }
        }
        if (result.blockHitResult() != null) {
            Vec3 target = result.blockHitResult().getLocation();
            Vec3 diff = player.position().subtract(target);
            target = target.add(diff.normalize().scale(Math.min(diff.length(), 2.0)));
            this.teleportPlayer(level, player, stack, target);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return super.use(level, player, hand);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(ESItems.SOUL_DEW.get()) || super.isValidRepairItem(stack, repairCandidate);
    }
}

