/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownShatteredBlade;
import cn.leolezury.eternalstarlight.common.registry.ESDataComponents;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;

public class ShatteredSwordItem
extends SwordItem {
    public ShatteredSwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public static boolean hasBlade(ItemStack itemStack) {
        return (Boolean)itemStack.getOrDefault(ESDataComponents.HAS_BLADE.get(), (Object)true);
    }

    public static void setHasBlade(ItemStack itemStack, boolean hasBlade) {
        itemStack.applyComponentsAndValidate(DataComponentPatch.builder().set(ESDataComponents.HAS_BLADE.get(), (Object)hasBlade).build());
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack itemStack = player.getItemInHand(interactionHand);
        if (ShatteredSwordItem.hasBlade(itemStack)) {
            ThrownShatteredBlade blade = new ThrownShatteredBlade(level, (LivingEntity)player, itemStack);
            blade.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 2.5f, 1.0f);
            if (player.hasInfiniteMaterials()) {
                blade.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            level.addFreshEntity((Entity)blade);
            level.playSound(null, blade.blockPosition(), (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS);
            if (!player.hasInfiniteMaterials()) {
                itemStack.hurtAndBreak(1, (LivingEntity)player, player.getUsedItemHand() == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                ShatteredSwordItem.setHasBlade(itemStack, false);
            }
            player.awardStat(Stats.ITEM_USED.get((Object)this));
            return InteractionResultHolder.success((Object)itemStack);
        }
        if (player.hasInfiniteMaterials()) {
            ShatteredSwordItem.setHasBlade(itemStack, true);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (!item.is(ESItems.SHATTERED_SWORD_BLADE.get())) continue;
            ShatteredSwordItem.setHasBlade(itemStack, true);
            item.shrink(1);
            return InteractionResultHolder.consume((Object)itemStack);
        }
        return InteractionResultHolder.fail((Object)itemStack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (!level.isClientSide && entity instanceof Player) {
            Player player = (Player)entity;
            if (!ShatteredSwordItem.hasBlade(stack)) {
                for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                    ItemStack item = player.getInventory().getItem(i);
                    if (!item.is(ESItems.SHATTERED_SWORD_BLADE.get())) continue;
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                    ShatteredSwordItem.setHasBlade(stack, true);
                    break;
                }
            }
        }
    }
}

