/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class DualWieldingSwordItem
extends SwordItem {
    public DualWieldingSwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND && player.getMainHandItem().is((Item)this)) {
            EntityHitResult entityResult;
            HitResult result = this.pick((Entity)player, player.blockInteractionRange(), player.entityInteractionRange());
            if (result instanceof EntityHitResult && (entityResult = (EntityHitResult)result).getType() != HitResult.Type.MISS) {
                ESDataAttachments.OFFHAND_ATTACK.setData((Entity)player, true);
                player.attack(entityResult.getEntity());
                ESDataAttachments.OFFHAND_ATTACK.setData((Entity)player, false);
            }
            ESDataAttachments.OFFHAND_ATTACK_STRENGTH_TIMER.setData((Entity)player, 0);
            player.swing(InteractionHand.OFF_HAND);
            player.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        return super.use(level, player, hand);
    }

    public void appendHoverText(ItemStack itemStack, Item.TooltipContext tooltipContext, List<Component> list, TooltipFlag tooltipFlag) {
        list.add(CommonComponents.EMPTY);
        list.add((Component)Component.translatable((String)"tooltip.eternal_starlight.dual_wielding").withStyle(ChatFormatting.GRAY));
        list.add((Component)Component.literal((String)" ").append((Component)Component.translatable((String)"tooltip.eternal_starlight.dual_wielding.offhand_attack").withStyle(ChatFormatting.BLUE)));
        super.appendHoverText(itemStack, tooltipContext, list, tooltipFlag);
    }

    protected HitResult pick(Entity entity, double blockInteractionRange, double entityInteractionRange) {
        AABB aabb;
        double maxRange = Math.max(blockInteractionRange, entityInteractionRange);
        double maxRangeSqr = Mth.square((double)maxRange);
        Vec3 eyePos = entity.getEyePosition();
        HitResult pickResult = entity.pick(maxRange, 1.0f, false);
        double dist = pickResult.getLocation().distanceToSqr(eyePos);
        if (pickResult.getType() != HitResult.Type.MISS) {
            maxRangeSqr = dist;
            maxRange = Math.sqrt(dist);
        }
        Vec3 viewVector = entity.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(viewVector.x * maxRange, viewVector.y * maxRange, viewVector.z * maxRange);
        EntityHitResult entityHitResult = ProjectileUtil.getEntityHitResult((Entity)entity, (Vec3)eyePos, (Vec3)endPos, (AABB)(aabb = entity.getBoundingBox().expandTowards(viewVector.scale(maxRange)).inflate(1.0, 1.0, 1.0)), e -> !e.isSpectator() && e.isPickable(), (double)maxRangeSqr);
        return entityHitResult != null && entityHitResult.getLocation().distanceToSqr(eyePos) < dist ? DualWieldingSwordItem.filterHitResult((HitResult)entityHitResult, eyePos, entityInteractionRange) : DualWieldingSwordItem.filterHitResult(pickResult, eyePos, blockInteractionRange);
    }

    private static HitResult filterHitResult(HitResult hitResult, Vec3 pos, double blockInteractionRange) {
        Vec3 location = hitResult.getLocation();
        if (!location.closerThan((Position)pos, blockInteractionRange)) {
            Direction direction = Direction.getNearest((double)(location.x - pos.x), (double)(location.y - pos.y), (double)(location.z - pos.z));
            return BlockHitResult.miss((Vec3)location, (Direction)direction, (BlockPos)BlockPos.containing((Position)location));
        }
        return hitResult;
    }
}

