/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.projectile.ChainOfSouls;
import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class ChainOfSoulsItem
extends Item {
    public ChainOfSoulsItem(Item.Properties properties) {
        super(properties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.getItemInHand(interactionHand);
        if (!level.isClientSide) {
            ChainOfSouls chain;
            ChainOfSouls hook;
            Entity entity = level.getEntity(ESDataAttachments.GRAPPLING.getData((Entity)player).intValue());
            ChainOfSouls chainOfSouls = hook = entity instanceof ChainOfSouls ? (chain = (ChainOfSouls)entity) : null;
            if (hook != null) {
                ChainOfSoulsItem.retrieve(level, player, hook);
            } else {
                stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)interactionHand));
                this.shoot(level, player, stack);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
    }

    private void shoot(Level level, Player player, ItemStack weapon) {
        if (!level.isClientSide) {
            level.addFreshEntity((Entity)new ChainOfSouls(level, player, weapon));
        }
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_THROW, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_START);
    }

    private static void retrieve(Level level, Player player, ChainOfSouls hook) {
        if (!level.isClientSide()) {
            hook.discard();
            ESDataAttachments.GRAPPLING.setData((Entity)player, -1);
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.FISHING_BOBBER_RETRIEVE, SoundSource.NEUTRAL, 1.0f, 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.gameEvent((Holder)GameEvent.ITEM_INTERACT_FINISH);
    }

    public int getEnchantmentValue() {
        return 1;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(ESItems.TENACIOUS_PETAL.get()) || repairCandidate.is(ESItems.TENACIOUS_VINE.get()) || super.isValidRepairItem(stack, repairCandidate);
    }
}

