/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.misc;

import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class ESBoat
extends Boat {
    private static final String TAG_TYPE = "type";
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.defineId(ESBoat.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public ESBoat(EntityType<? extends ESBoat> type, Level level) {
        super(type, level);
        this.blocksBuilding = true;
    }

    public ESBoat(Level level, double x, double y, double z) {
        this(ESEntities.BOAT.get(), level);
        this.setPos(x, y, z);
        this.xo = x;
        this.yo = y;
        this.zo = z;
    }

    public Type getESBoatType() {
        return Type.byId((Integer)this.getEntityData().get(BOAT_TYPE));
    }

    public Item getDropItem() {
        return switch (this.getESBoatType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ESItems.LUNAR_BOAT.get();
            case 1 -> ESItems.NORTHLAND_BOAT.get();
            case 2 -> ESItems.BANYIN_BOAT.get();
            case 3 -> ESItems.SCARLET_BOAT.get();
            case 4 -> ESItems.TORREYA_BOAT.get();
            case 5 -> ESItems.JINGLESTEM_RAFT.get();
            case 6 -> ESItems.CRADLEWOOD_BOAT.get();
        };
    }

    protected Vec3 getPassengerAttachmentPoint(Entity entity, EntityDimensions entityDimensions, float f) {
        Vec3 point = super.getPassengerAttachmentPoint(entity, entityDimensions, f);
        if (this.getESBoatType() == Type.JINGLESTEM) {
            return new Vec3(point.x, point.y / 3.0 * 8.0, point.z);
        }
        return point;
    }

    public void setStarlightBoatType(Type boatType) {
        this.getEntityData().set(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(BOAT_TYPE, (Object)Type.LUNAR.ordinal());
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString(TAG_TYPE, this.getESBoatType().getName());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains(TAG_TYPE, 8)) {
            this.setStarlightBoatType(Type.getTypeFromString(compound.getString(TAG_TYPE)));
        }
    }

    public static enum Type {
        LUNAR(ESBlocks.LUNAR_PLANKS.get(), "lunar"),
        NORTHLAND(ESBlocks.NORTHLAND_PLANKS.get(), "northland"),
        BANYIN(ESBlocks.BANYIN_PLANKS.get(), "banyin"),
        SCARLET(ESBlocks.SCARLET_PLANKS.get(), "scarlet"),
        TORREYA(ESBlocks.TORREYA_PLANKS.get(), "torreya"),
        JINGLESTEM(ESBlocks.JINGLESTEM_PLANKS.get(), "jinglestem"),
        CRADLEWOOD(ESBlocks.CRADLEWOOD_PLANKS.get(), "cradlewood");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] SLBoat$type = Type.values();
            if (id < 0 || id >= SLBoat$type.length) {
                id = 0;
            }
            return SLBoat$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] boatTypeArray;
            for (Type type : boatTypeArray = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return boatTypeArray[0];
        }
    }
}

