/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.data.ESSeekerVariants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record SeekerVariant(ResourceLocation texture, ResourceLocation textureFull, ResourceLocation glowTexture, ResourceLocation glowTextureFull, ResourceLocation tentacleTexture, ResourceLocation tentacleTextureFull, ResourceLocation tentacleEndTexture, ResourceLocation tentacleEndTextureFull, int particleColor, HolderSet<Biome> biomes) {
    public static final Codec<SeekerVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(SeekerVariant::texture), (App)ResourceLocation.CODEC.fieldOf("glow_texture").forGetter(SeekerVariant::glowTexture), (App)ResourceLocation.CODEC.fieldOf("tentacle_texture").forGetter(SeekerVariant::tentacleTexture), (App)ResourceLocation.CODEC.fieldOf("tentacle_end_texture").forGetter(SeekerVariant::tentacleEndTexture), (App)Codec.INT.fieldOf("particle_color").forGetter(SeekerVariant::particleColor), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(SeekerVariant::biomes)).apply((Applicative)instance, SeekerVariant::new));

    public SeekerVariant(ResourceLocation texture, ResourceLocation glowTexture, ResourceLocation tentacleTexture, ResourceLocation tentacleEndTexture, int particleColor, HolderSet<Biome> biomes) {
        this(texture, SeekerVariant.fullTextureId(texture), glowTexture, SeekerVariant.fullTextureId(glowTexture), tentacleTexture, SeekerVariant.fullTextureId(tentacleTexture), tentacleEndTexture, SeekerVariant.fullTextureId(tentacleEndTexture), particleColor, biomes);
    }

    private static ResourceLocation fullTextureId(ResourceLocation location) {
        return location.withPath(string -> "textures/" + string + ".png");
    }

    public static Holder<SeekerVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> holder) {
        Registry registry = registryAccess.registryOrThrow(ESRegistries.SEEKER_VARIANT);
        Optional<Holder.Reference> optional = registry.holders().filter(reference -> ((SeekerVariant)reference.value()).biomes().contains(holder)).findFirst().or(() -> registry.getHolder(ESSeekerVariants.LUNAR));
        Objects.requireNonNull(registry);
        return (Holder)optional.or(() -> ((Registry)registry).getAny()).orElseThrow();
    }
}

