/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.data.ESSeekerVariants;
import cn.leolezury.eternalstarlight.common.entity.living.monster.SeekerVariant;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Seeker
extends Monster
implements VariantHolder<Holder<SeekerVariant>> {
    private static final String TAG_VARIANT = "variant";
    public static final float TENTACLE_LENGTH = 5.0f;
    private static final byte EVENT_MOVE = 100;
    private static final byte EVENT_ATTACK = 101;
    protected static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(Seeker.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    protected static final EntityDataAccessor<Float> SEEKER_Y_ROT = SynchedEntityData.defineId(Seeker.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    protected static final EntityDataAccessor<Float> SEEKER_X_ROT = SynchedEntityData.defineId(Seeker.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private float oldSeekerXRot;
    private float seekerXRot;
    private float oldSeekerYRot;
    private float seekerYRot;
    public AnimationState moveAnimationState = new AnimationState();
    public AnimationState attackAnimationState = new AnimationState();
    private Vec3 nextMovement = Vec3.ZERO;
    private int moveTicks;
    private int moveCooldown;
    private int attackTicks;
    private int attackCooldown;
    private float attackXRot;
    private float attackYRot;

    public ResourceLocation getVariantId() {
        return ResourceLocation.parse((String)((String)this.getEntityData().get(VARIANT)));
    }

    public void setVariantId(ResourceLocation variant) {
        this.getEntityData().set(VARIANT, (Object)variant.toString());
    }

    public void setVariant(Holder<SeekerVariant> variant) {
        ResourceLocation key;
        if (variant.isBound() && (key = this.level().registryAccess().registryOrThrow(ESRegistries.SEEKER_VARIANT).getKey((Object)((SeekerVariant)variant.value()))) != null) {
            this.setVariantId(key);
        }
    }

    public Holder<SeekerVariant> getVariant() {
        ResourceLocation key = this.getVariantId();
        Registry variants = this.level().registryAccess().registryOrThrow(ESRegistries.SEEKER_VARIANT);
        Optional optional = variants.getHolder(key);
        return (Holder)optional.orElse((Holder.Reference)variants.getHolder(ESSeekerVariants.LUNAR).orElseThrow());
    }

    public float getSeekerYRot() {
        return ((Float)this.getEntityData().get(SEEKER_Y_ROT)).floatValue();
    }

    public void setSeekerYRot(float yRot) {
        this.getEntityData().set(SEEKER_Y_ROT, (Object)Float.valueOf(yRot));
    }

    public float getSeekerXRot() {
        return ((Float)this.getEntityData().get(SEEKER_X_ROT)).floatValue();
    }

    public void setSeekerXRot(float xRot) {
        this.getEntityData().set(SEEKER_X_ROT, (Object)Float.valueOf(xRot));
    }

    public Seeker(EntityType<? extends Seeker> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)ESSeekerVariants.LUNAR.location().toString()).define(SEEKER_X_ROT, (Object)Float.valueOf(0.0f)).define(SEEKER_Y_ROT, (Object)Float.valueOf(0.0f));
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.seeker.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.seeker.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.seeker.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.seeker.followRange()).add(Attributes.MOVEMENT_SPEED, 0.0).add(Attributes.FLYING_SPEED, 1.0);
    }

    public float getSeekerXRot(float f) {
        return Mth.rotLerp((float)f, (float)this.oldSeekerXRot, (float)this.seekerXRot);
    }

    public float getSeekerYRot(float f) {
        return Mth.rotLerp((float)f, (float)this.oldSeekerYRot, (float)this.seekerYRot);
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
        if (!this.level().isClientSide) {
            if (this.isAlive() && !this.isNoAi()) {
                Level tooHigh2;
                LivingEntity target = this.getTarget();
                if (target != null && !target.isAlive()) {
                    this.setTarget(null);
                    target = null;
                }
                if (this.moveTicks > 0) {
                    --this.moveTicks;
                }
                if (this.moveCooldown > 0) {
                    --this.moveCooldown;
                }
                if (this.attackTicks > 0) {
                    --this.attackTicks;
                }
                if (this.attackCooldown > 0) {
                    --this.attackCooldown;
                }
                if (this.moveTicks <= 0 && this.attackTicks <= 0 && this.moveCooldown <= 0) {
                    this.level().broadcastEntityEvent((Entity)this, (byte)100);
                    this.moveTicks = 20;
                    this.moveCooldown = target == null ? 50 : 30;
                    BlockHitResult heightResult = this.level().clip(new ClipContext(this.position(), this.position().subtract(0.0, 10.0, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
                    boolean tooHigh2 = heightResult.getType() == HitResult.Type.MISS;
                    for (int i = 0; i < 32; ++i) {
                        if (target != null && i == 0) {
                            Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                            Vec3 selfPos = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
                            Vec3 wanted = ESMathUtil.rotationToPosition(targetPos, 3.0f, (this.getRandom().nextFloat() - 0.5f) * 30.0f, ESMathUtil.positionToYaw(targetPos, selfPos) + 15.0f);
                            this.nextMovement = wanted.subtract(this.position()).normalize();
                        } else {
                            this.nextMovement = new Vec3((double)(this.getRandom().nextFloat() - 0.5f), tooHigh2 ? (double)(-Math.abs(this.getRandom().nextFloat() - 0.5f)) : (double)(this.getRandom().nextFloat() - 0.5f), (double)(this.getRandom().nextFloat() - 0.5f)).normalize();
                        }
                        BlockHitResult result = this.level().clip(new ClipContext(this.position(), this.position().add(this.nextMovement.scale(this.getBoundingBox().getSize() + 3.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.ANY, (Entity)this));
                        if (result.getType() == HitResult.Type.MISS && (target != null && i == 0 || Mth.degreesDifferenceAbs((float)this.getSeekerXRot(), (float)ESMathUtil.positionToPitch(this.nextMovement)) <= 90.0f && Mth.degreesDifferenceAbs((float)this.getSeekerYRot(), (float)ESMathUtil.positionToYaw(this.nextMovement)) <= 90.0f)) break;
                    }
                    this.setSeekerXRot(ESMathUtil.positionToPitch(this.nextMovement));
                    this.setSeekerYRot(ESMathUtil.positionToYaw(this.nextMovement));
                    this.setYRot(this.getSeekerYRot() - 90.0f);
                }
                if (this.moveTicks == 15 && (tooHigh2 = this.level()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)tooHigh2;
                    this.hurtMarked = true;
                    this.setDeltaMovement(this.nextMovement.scale(this.getAttributeValue(Attributes.FLYING_SPEED) * (target == null ? 0.2 : 0.4)));
                    for (int i = 0; i < 64; ++i) {
                        Vec3 particleMovement = this.nextMovement.add((this.getRandom().nextDouble() - 0.5) * 0.5, (this.getRandom().nextDouble() - 0.5) * 0.5, (this.getRandom().nextDouble() - 0.5) * 0.5).normalize();
                        double particleSpeed = 0.1 + this.getRandom().nextDouble() * 0.4;
                        ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, (Entity)this, new ParticlePacket((ParticleOptions)ColorParticleOption.create(ESParticles.COLORED_INK.get(), (int)((SeekerVariant)this.getVariant().value()).particleColor()), this.getX() - this.nextMovement.x() * 0.5, this.getY() + (double)(this.getBbHeight() / 2.0f) - this.nextMovement.y() * 0.5, this.getZ() - this.nextMovement.z() * 0.5, -particleMovement.x() * particleSpeed, -particleMovement.y() * particleSpeed, -particleMovement.z() * particleSpeed));
                    }
                }
                if (target != null) {
                    boolean canReachTarget;
                    Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                    Vec3 selfPos = this.position().add(0.0, (double)(this.getBbHeight() / 2.0f), 0.0);
                    if (this.attackTicks <= 0) {
                        this.attackXRot = ESMathUtil.positionToPitch(selfPos, targetPos);
                        this.attackYRot = ESMathUtil.positionToYaw(selfPos, targetPos);
                    }
                    AABB aabb = target.getBoundingBox().inflate((double)(target.getPickRadius() + 0.5f));
                    Vec3 endPos = ESMathUtil.rotationToPosition(selfPos, 5.0f, this.attackXRot, this.attackYRot);
                    boolean bl = canReachTarget = (aabb.contains(selfPos) || aabb.clip(selfPos, endPos).isPresent()) && this.hasLineOfSight((Entity)target);
                    if (this.moveTicks <= 0 && this.attackTicks <= 0 && this.attackCooldown <= 0 && canReachTarget) {
                        this.attackTicks = 30;
                        this.attackCooldown = 50;
                        this.setDeltaMovement(Vec3.ZERO);
                        this.level().broadcastEntityEvent((Entity)this, (byte)101);
                    }
                    if (this.attackTicks > 10) {
                        this.setSeekerXRot(Mth.rotLerp((float)0.2f, (float)this.getSeekerXRot(), (float)(-this.attackXRot)));
                        this.setSeekerYRot(Mth.rotLerp((float)0.2f, (float)this.getSeekerYRot(), (float)(this.attackYRot + 180.0f)));
                        this.setYRot(this.getSeekerYRot() - 90.0f);
                    }
                    if (this.attackTicks == 10) {
                        this.setSeekerXRot(-this.attackXRot);
                        this.setSeekerYRot(this.attackYRot + 180.0f);
                        this.setYRot(this.getSeekerYRot() - 90.0f);
                        if (canReachTarget) {
                            this.doHurtTarget((Entity)target);
                        }
                    }
                }
            }
        } else {
            this.oldSeekerXRot = this.seekerXRot;
            this.oldSeekerYRot = this.seekerYRot;
            this.seekerXRot = this.getSeekerXRot();
            this.seekerYRot = this.getSeekerYRot();
        }
    }

    public void handleEntityEvent(byte b) {
        if (b == 100) {
            this.moveAnimationState.start(this.tickCount);
        } else if (b == 101) {
            this.attackAnimationState.start(this.tickCount);
        } else {
            super.handleEntityEvent(b);
        }
    }

    public boolean causeFallDamage(float f, float g, DamageSource damageSource) {
        return false;
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData data) {
        this.setVariant(SeekerVariant.getSpawnVariant(level.registryAccess(), (Holder<Biome>)level.getBiome(this.blockPosition())));
        return super.finalizeSpawn(level, instance, spawnType, data);
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ESSoundEvents.SEEKER_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.SEEKER_DEATH.get();
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        this.setVariantId((ResourceLocation)ResourceLocation.read((String)compoundTag.getString(TAG_VARIANT)).getOrThrow());
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putString(TAG_VARIANT, this.getVariantId().toString());
    }

    public static boolean checkSeekerSpawnRules(EntityType<? extends Seeker> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Seeker.checkAnyLightMonsterSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && ESConfig.INSTANCE.mobsConfig.seeker.canSpawn();
    }
}

