/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorPhase;
import cn.leolezury.eternalstarlight.common.entity.projectile.PermafrostSpit;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class PermafrostSneezePhase
extends BehaviorPhase<Permafrost> {
    public static final int ID = 5;

    public PermafrostSneezePhase() {
        super(5, 1, 99, 300);
    }

    @Override
    public boolean canStart(Permafrost entity, boolean cooldownOver) {
        return cooldownOver && this.canReachTarget(entity, 20.0);
    }

    @Override
    public void onStart(Permafrost entity) {
    }

    @Override
    public void tick(Permafrost entity) {
        Level level = entity.level();
        if (entity.getTarget() != null) {
            LivingEntity target = entity.getTarget();
            entity.lookAt(EntityAnchorArgument.Anchor.EYES, target.getEyePosition());
            if (entity.getBehaviorTicks() == 75) {
                entity.playSound(ESSoundEvents.PERMAFROST_SNEEZE.get());
                Vec3 launchPos = entity.getEyePosition();
                Vec3 targetPos = target.position().add(0.0, (double)(target.getBbHeight() / 2.0f), 0.0);
                Vec3 delta = targetPos.subtract(launchPos).normalize();
                PermafrostSpit spit = new PermafrostSpit(level, (LivingEntity)entity);
                spit.shoot(delta.x, delta.y, delta.z, 1.5f, 0.1f);
                spit.setPos(launchPos);
                level.addFreshEntity((Entity)spit);
            }
        }
    }

    @Override
    public boolean canContinue(Permafrost entity) {
        return true;
    }

    @Override
    public void onStop(Permafrost entity) {
    }
}

