/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.boss.golem;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.PermafrostMeleeEndPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.PermafrostMeleePhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.PermafrostMeleeTransitionPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.PermafrostRangedPhase;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.PermafrostSneezePhase;
import cn.leolezury.eternalstarlight.common.entity.living.goal.LookAtTargetGoal;
import cn.leolezury.eternalstarlight.common.entity.living.goal.RandomFlyGoal;
import cn.leolezury.eternalstarlight.common.entity.living.phase.BehaviorManager;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import cn.leolezury.eternalstarlight.common.util.ModelPartPose;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class Permafrost
extends ESBoss {
    private final BehaviorManager<Permafrost> behaviorManager = new BehaviorManager<Permafrost>(this, List.of(new PermafrostMeleePhase(), new PermafrostMeleeTransitionPhase(), new PermafrostMeleeEndPhase(), new PermafrostRangedPhase(), new PermafrostSneezePhase()));
    public AnimationState idleAnimationState = new AnimationState();
    public AnimationState meleeAnimationState = new AnimationState();
    public AnimationState meleeTransitionAnimationState = new AnimationState();
    public AnimationState meleeEndAnimationState = new AnimationState();
    public AnimationState rangedAnimationState = new AnimationState();
    public AnimationState sneezeAnimationState = new AnimationState();
    public Vec3 smokePos = Vec3.ZERO;
    public final List<Pair<Vec3, Map<String, ModelPartPose>>> trailSnapshots = new ArrayList<Pair<Vec3, Map<String, ModelPartPose>>>();
    public float lastTrailTick = 0.0f;

    public Permafrost(EntityType<? extends Permafrost> entityType, Level level) {
        super(entityType, level);
        this.moveControl = new FlyingMoveControl((Mob)this, 5, true);
    }

    public boolean shouldAddTrailSnapshot() {
        return this.getBehaviorState() == 1 || this.getBehaviorState() == 2 || this.getBehaviorState() == 3 && this.getBehaviorTicks() < 3;
    }

    protected PathNavigation createNavigation(Level level) {
        FlyingPathNavigation navigation = new FlyingPathNavigation(this, (Mob)this, level){

            public boolean isStableDestination(BlockPos blockPos) {
                return this.level.getBlockState(blockPos).isAir();
            }
        };
        navigation.setCanOpenDoors(true);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PermafrostFlyToTargetGoal());
        this.goalSelector.addGoal(2, (Goal)new RandomFlyGoal((PathfinderMob)this){

            @Override
            public boolean canUse() {
                return super.canUse() && Permafrost.this.getTarget() == null && Permafrost.this.getBehaviorState() == 0;
            }

            @Override
            public boolean canContinueToUse() {
                return super.canContinueToUse() && Permafrost.this.getTarget() == null && Permafrost.this.getBehaviorState() == 0;
            }
        });
        this.goalSelector.addGoal(3, (Goal)new LookAtTargetGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Permafrost.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.createMonsterAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.permafrost.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.permafrost.armor()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.permafrost.followRange()).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.8).add(Attributes.ATTACK_DAMAGE, 12.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.75);
    }

    public void stopAllAnimStates() {
        this.meleeAnimationState.stop();
        this.meleeTransitionAnimationState.stop();
        this.meleeEndAnimationState.stop();
        this.rangedAnimationState.stop();
        this.sneezeAnimationState.stop();
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)BEHAVIOR_STATE) && this.getBehaviorState() != 0) {
            this.stopAllAnimStates();
            switch (this.getBehaviorState()) {
                case 1: {
                    this.meleeAnimationState.start(this.tickCount);
                    break;
                }
                case 2: {
                    this.meleeTransitionAnimationState.start(this.tickCount);
                    break;
                }
                case 3: {
                    this.meleeEndAnimationState.start(this.tickCount);
                    break;
                }
                case 4: {
                    this.rangedAnimationState.start(this.tickCount);
                    break;
                }
                case 5: {
                    this.sneezeAnimationState.start(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(accessor);
    }

    public boolean causeFallDamage(float f, float g, DamageSource damageSource) {
        return false;
    }

    public boolean isAlliedTo(Entity entity) {
        return super.isAlliedTo(entity) || entity.getType().is(ESTags.EntityTypes.STARLIGHT_GOLEM_ALLYS);
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            LivingEntity target;
            if (this.getTarget() != null && !this.getTarget().isAlive()) {
                this.setTarget(null);
            }
            if (!this.isNoAi() && this.isAlive()) {
                this.behaviorManager.tick();
            }
            if (this.getBehaviorState() == 0 && (target = this.getTarget()) != null && this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0)).contains(this.getTarget())) {
                this.hurtMarked = true;
                this.addDeltaMovement(this.position().subtract(target.position()).multiply(1.0, 0.0, 1.0).normalize().scale(0.1));
            }
        } else {
            if (!this.onGround() && this.smokePos.distanceTo(this.position()) < (double)this.getBbHeight()) {
                Vec3 pos = this.smokePos.subtract(0.0, 0.8125, 0.0);
                for (int i = 0; i < 5; ++i) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.WHITE_SMOKE, pos.x + (double)(this.getBbWidth() / 2.0f * (this.getRandom().nextFloat() - 0.5f)), pos.y, pos.z + (double)(this.getBbWidth() / 2.0f * (this.getRandom().nextFloat() - 0.5f)), 0.0, -0.15, 0.0);
                }
            }
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public boolean doHurtTarget(Entity entity) {
        boolean success = super.doHurtTarget(entity);
        if (success && entity.canFreeze()) {
            entity.setTicksFrozen(Math.min(entity.getTicksFrozen() + 150, 300));
        }
        return success;
    }

    protected SoundEvent getHurtSound(DamageSource source) {
        return ESSoundEvents.PERMAFROST_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return ESSoundEvents.PERMAFROST_DEATH.get();
    }

    @Override
    public boolean shouldPlayBossMusic() {
        return false;
    }

    public static boolean checkPermafrostSpawnRules(EntityType<? extends Permafrost> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Permafrost.checkAnyLightMonsterSpawnRules(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && ESConfig.INSTANCE.mobsConfig.permafrost.canSpawn();
    }

    public class PermafrostFlyToTargetGoal
    extends Goal {
        public PermafrostFlyToTargetGoal() {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            return Permafrost.this.getBehaviorState() == 0 && Permafrost.this.getTarget() != null;
        }

        public boolean canContinueToUse() {
            return Permafrost.this.getBehaviorState() == 0 && Permafrost.this.getTarget() != null;
        }

        public boolean requiresUpdateEveryTick() {
            return true;
        }

        public void tick() {
            LivingEntity entity = Permafrost.this.getTarget();
            if (entity != null) {
                Vec3 target = entity.position();
                BlockHitResult result = Permafrost.this.level().clip(new ClipContext(target.add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0), target.add(0.0, (double)(entity.getBbHeight() / 2.0f + Permafrost.this.getBbHeight()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)Permafrost.this));
                target = result.getType() != HitResult.Type.MISS ? result.getLocation() : target.add(0.0, (double)(entity.getBbHeight() / 2.0f + Permafrost.this.getBbHeight()), 0.0);
                Permafrost.this.getNavigation().moveTo(target.x, target.y - (double)Permafrost.this.getBbHeight(), target.z, 1.0);
            }
        }
    }
}

