/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.data.ESRegistries;
import cn.leolezury.eternalstarlight.common.data.ESShimmerLacewingVariants;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public record ShimmerLacewingVariant(ResourceLocation texture, ResourceLocation textureFull, ResourceLocation glowTexture, ResourceLocation glowTextureFull, HolderSet<Biome> biomes) {
    public static final Codec<ShimmerLacewingVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("texture").forGetter(ShimmerLacewingVariant::texture), (App)ResourceLocation.CODEC.fieldOf("glow_texture").forGetter(ShimmerLacewingVariant::glowTexture), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.BIOME).fieldOf("biomes").forGetter(ShimmerLacewingVariant::biomes)).apply((Applicative)instance, ShimmerLacewingVariant::new));

    public ShimmerLacewingVariant(ResourceLocation texture, ResourceLocation glowTexture, HolderSet<Biome> biomes) {
        this(texture, ShimmerLacewingVariant.fullTextureId(texture), glowTexture, ShimmerLacewingVariant.fullTextureId(glowTexture), biomes);
    }

    private static ResourceLocation fullTextureId(ResourceLocation location) {
        return location.withPath(string -> "textures/" + string + ".png");
    }

    public static Holder<ShimmerLacewingVariant> getSpawnVariant(RegistryAccess registryAccess, Holder<Biome> holder) {
        Registry registry = registryAccess.registryOrThrow(ESRegistries.SHIMMER_LACEWING_VARIANT);
        Optional<Holder.Reference> optional = registry.holders().filter(reference -> ((ShimmerLacewingVariant)reference.value()).biomes().contains(holder)).findFirst().or(() -> registry.getHolder(ESShimmerLacewingVariants.RIVER));
        Objects.requireNonNull(registry);
        return (Holder)optional.or(() -> ((Registry)registry).getAny()).orElseThrow();
    }
}

