/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.interfaces.Charger;
import cn.leolezury.eternalstarlight.common.entity.living.goal.ChargeAttackGoal;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class AuroraDeer
extends Animal
implements Charger {
    private static final String TAG_LEFT_ANTLER = "left_antler";
    private static final String TAG_RIGHT_ANTLER = "right_antler";
    private static final String TAG_SNOW = "snow";
    private static final String TAG_SNOW_PROGRESS = "snow_progress";
    private static final Ingredient FOOD_ITEMS = Ingredient.of(ESTags.Items.AURORA_DEER_FOOD);
    protected static final EntityDataAccessor<Boolean> LEFT_ANTLER = SynchedEntityData.defineId(AuroraDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> RIGHT_ANTLER = SynchedEntityData.defineId(AuroraDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> SNOW = SynchedEntityData.defineId(AuroraDeer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public AnimationState idleAnimationState = new AnimationState();
    private boolean charging = false;
    private int notChargingTicks = 200;
    private int snowProgress = 2000;

    public boolean hasLeftAntler() {
        return (Boolean)this.getEntityData().get(LEFT_ANTLER);
    }

    public boolean hasRightAntler() {
        return (Boolean)this.getEntityData().get(RIGHT_ANTLER);
    }

    public boolean hasSnow() {
        return (Boolean)this.getEntityData().get(SNOW);
    }

    public void setHasSnow(boolean hasSnow) {
        this.getEntityData().set(SNOW, (Object)hasSnow);
    }

    public AuroraDeer(EntityType<? extends AuroraDeer> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void setCharging(boolean charging) {
        this.charging = charging;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LEFT_ANTLER, (Object)true).define(RIGHT_ANTLER, (Object)true).define(SNOW, (Object)true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new ChargeAttackGoal((PathfinderMob)this, false, 2.0f, 80, 80, 0.6f){
            private boolean antlerBroken;
            {
                this.antlerBroken = false;
            }

            @Override
            public boolean canUse() {
                return super.canUse() && AuroraDeer.this.getHealth() / AuroraDeer.this.getMaxHealth() >= 0.5f && (AuroraDeer.this.hasLeftAntler() || AuroraDeer.this.hasRightAntler());
            }

            @Override
            public void start() {
                super.start();
                this.antlerBroken = false;
            }

            @Override
            public void tick() {
                super.tick();
                if (AuroraDeer.this.charging && !this.antlerBroken) {
                    Vec3 vec3 = AuroraDeer.this.getDeltaMovement().multiply(1.0, 0.0, 1.0).normalize();
                    AABB box = AuroraDeer.this.getBoundingBox().move(vec3);
                    BlockPos fromPos = BlockPos.containing((double)(box.minX + 1.0E-7), (double)(box.minY + 1.0E-7), (double)(box.minZ + 1.0E-7));
                    BlockPos toPos = BlockPos.containing((double)(box.maxX - 1.0E-7), (double)(box.maxY - 1.0E-7), (double)(box.maxZ - 1.0E-7));
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    for (int i = fromPos.getX(); i <= toPos.getX(); ++i) {
                        for (int j = fromPos.getY(); j <= toPos.getY(); ++j) {
                            for (int k = fromPos.getZ(); k <= toPos.getZ(); ++k) {
                                mutableBlockPos.set(i, j, k);
                                BlockState blockState = AuroraDeer.this.level().getBlockState((BlockPos)mutableBlockPos);
                                if (!blockState.is(BlockTags.LOGS) && !blockState.is(BlockTags.SNAPS_GOAT_HORN) && !blockState.is(ESTags.Blocks.BASE_STONE_STARLIGHT)) continue;
                                AuroraDeer.this.randomlyBreakAntler();
                                this.antlerBroken = true;
                                this.stop();
                                return;
                            }
                        }
                    }
                }
            }
        });
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 1.25){

            public boolean canUse() {
                return super.canUse() && (AuroraDeer.this.getHealth() / AuroraDeer.this.getMaxHealth() < 0.5f || !AuroraDeer.this.hasLeftAntler() && !AuroraDeer.this.hasRightAntler());
            }
        });
        this.goalSelector.addGoal(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(4, (Goal)new TemptGoal((PathfinderMob)this, 1.2, (Predicate)FOOD_ITEMS, false));
        this.goalSelector.addGoal(5, (Goal)new FollowParentGoal((Animal)this, 1.1));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return super.canUse() && AuroraDeer.this.notChargingTicks >= 200;
            }
        });
        this.goalSelector.addGoal(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ESConfig.INSTANCE.mobsConfig.auroraDeer.maxHealth()).add(Attributes.ARMOR, ESConfig.INSTANCE.mobsConfig.auroraDeer.armor()).add(Attributes.ATTACK_DAMAGE, ESConfig.INSTANCE.mobsConfig.auroraDeer.attackDamage()).add(Attributes.FOLLOW_RANGE, ESConfig.INSTANCE.mobsConfig.auroraDeer.followRange()).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean isFood(ItemStack stack) {
        return FOOD_ITEMS.test(stack);
    }

    public void aiStep() {
        super.aiStep();
        this.notChargingTicks = this.charging ? 0 : ++this.notChargingTicks;
        if (!this.level().isClientSide) {
            boolean snow = this.hasSnow();
            this.snowProgress = (double)((Biome)this.level().getBiome(this.blockPosition()).value()).getBaseTemperature() < 0.15 ? Math.min(this.snowProgress + 1, 2000) : Math.max(this.snowProgress - 1, 0);
            if (snow && this.snowProgress < 1000) {
                this.setHasSnow(false);
            }
            if (!snow && this.snowProgress >= 1000) {
                this.setHasSnow(true);
            }
        } else {
            this.idleAnimationState.startIfStopped(this.tickCount);
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (this.hasSnow() && stack.is(ItemTags.SHOVELS)) {
            this.setHasSnow(false);
            this.snowProgress = 0;
            int i = 1 + this.getRandom().nextInt(3);
            for (int j = 0; j < i; ++j) {
                ItemEntity itemEntity = this.spawnAtLocation((ItemLike)Items.SNOWBALL, 1);
                if (itemEntity == null) continue;
                itemEntity.setDeltaMovement(itemEntity.getDeltaMovement().add((double)((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f), (double)(this.getRandom().nextFloat() * 0.05f), (double)((this.getRandom().nextFloat() - this.getRandom().nextFloat()) * 0.1f)));
            }
            stack.hurtAndBreak(1, (LivingEntity)player, player.getEquipmentSlotForItem(stack));
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    public void randomlyBreakAntler() {
        if (this.getRandom().nextInt(8) == 0) {
            EntityDataAccessor<Boolean> accessor;
            EntityDataAccessor<Boolean> entityDataAccessor = accessor = this.getRandom().nextBoolean() ? LEFT_ANTLER : RIGHT_ANTLER;
            if (!this.hasLeftAntler()) {
                accessor = RIGHT_ANTLER;
            }
            if (!this.hasRightAntler()) {
                accessor = LEFT_ANTLER;
            }
            if (!this.hasLeftAntler() && !this.hasRightAntler()) {
                return;
            }
            this.getEntityData().set(accessor, (Object)false);
            Level level = this.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
            }
            this.spawnAtLocation((ItemLike)ESItems.AURORA_DEER_ANTLER.get());
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains(TAG_LEFT_ANTLER, 1)) {
            this.getEntityData().set(LEFT_ANTLER, (Object)compoundTag.getBoolean(TAG_LEFT_ANTLER));
        }
        if (compoundTag.contains(TAG_RIGHT_ANTLER, 1)) {
            this.getEntityData().set(RIGHT_ANTLER, (Object)compoundTag.getBoolean(TAG_RIGHT_ANTLER));
        }
        if (compoundTag.contains(TAG_SNOW, 1)) {
            this.setHasSnow(compoundTag.getBoolean(TAG_SNOW));
        }
        if (compoundTag.contains(TAG_SNOW_PROGRESS, 3)) {
            this.snowProgress = compoundTag.getInt(TAG_SNOW_PROGRESS);
        }
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putBoolean(TAG_LEFT_ANTLER, this.hasLeftAntler());
        compoundTag.putBoolean(TAG_RIGHT_ANTLER, this.hasRightAntler());
        compoundTag.putBoolean(TAG_SNOW, this.hasSnow());
        compoundTag.putInt(TAG_SNOW_PROGRESS, this.snowProgress);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ESSoundEvents.AURORA_DEER_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ESSoundEvents.AURORA_DEER_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ESSoundEvents.AURORA_DEER_DEATH.get();
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel serverLevel, AgeableMob ageableMob) {
        return (AgeableMob)ESEntities.AURORA_DEER.get().create((Level)serverLevel);
    }

    public static boolean checkAuroraDeerSpawnRules(EntityType<? extends AuroraDeer> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.getBlockState(pos.below()).is(BlockTags.ANIMALS_SPAWNABLE_ON) && ESConfig.INSTANCE.mobsConfig.auroraDeer.canSpawn();
    }
}

