/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.attack;

import cn.leolezury.eternalstarlight.common.registry.ESDataAttachments;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.Nullable;

public abstract class Whip
extends Entity {
    private static final String TAG_SPAWNED_TICKS = "spawned_ticks";
    private static final String TAG_OWNER = "owner";
    private static final String TAG_WEAPON = "weapon";
    protected static final EntityDataAccessor<Integer> SPAWNED_TICKS = SynchedEntityData.defineId(Whip.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> OWNER_ID = SynchedEntityData.defineId(Whip.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> FOIL = SynchedEntityData.defineId(Whip.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    @Nullable
    private ItemStack firedFromWeapon;
    @Nullable
    private Entity owner;
    @Nullable
    private UUID ownerId;
    private int oldAnimationTicks;
    private int animationTicks;

    public int getSpawnedTicks() {
        return (Integer)this.getEntityData().get(SPAWNED_TICKS);
    }

    public void setSpawnedTicks(int spawnedTicks) {
        this.getEntityData().set(SPAWNED_TICKS, (Object)spawnedTicks);
    }

    private void setOwnerId(int ownerId) {
        this.getEntityData().set(OWNER_ID, (Object)ownerId);
    }

    public int getOwnerId() {
        return (Integer)this.getEntityData().get(OWNER_ID);
    }

    public Entity getOwner() {
        return this.level().isClientSide ? this.level().getEntity(this.getOwnerId()) : this.owner;
    }

    public void setOwner(Entity owner) {
        this.ownerId = owner != null ? owner.getUUID() : null;
        this.owner = owner;
        this.updateOwnerInfo(this);
    }

    public float getAnimationTicks(float partialTicks) {
        return Mth.lerp((float)partialTicks, (float)this.oldAnimationTicks, (float)this.animationTicks);
    }

    public Whip(EntityType<? extends Whip> entityType, Level level) {
        super(entityType, level);
        this.noCulling = true;
    }

    public Whip(EntityType<? extends Whip> entityType, Level level, Player player, @Nullable ItemStack weapon) {
        this(entityType, level);
        this.setOwner((Entity)player);
        this.setPos(player.getEyePosition());
        this.firedFromWeapon = weapon;
        if (this.firedFromWeapon != null) {
            this.entityData.set(FOIL, (Object)this.firedFromWeapon.hasFoil());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(SPAWNED_TICKS, (Object)0).define(OWNER_ID, (Object)-1).define(FOIL, (Object)false);
    }

    public boolean shouldRenderAtSqrDistance(double d) {
        return true;
    }

    protected double getDefaultGravity() {
        return 0.0;
    }

    public boolean isFoil() {
        return (Boolean)this.entityData.get(FOIL);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            Level level;
            if (this.owner == null && this.ownerId != null && (level = this.level()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Entity entity = serverLevel.getEntity(this.ownerId);
                if (entity != null) {
                    this.owner = entity;
                }
                if (this.owner == null) {
                    this.ownerId = null;
                }
            }
            this.setOwnerId(this.owner != null ? this.owner.getId() : -1);
            if (this.getSpawnedTicks() >= this.getLifespan()) {
                this.discard();
            }
            this.setSpawnedTicks(this.getSpawnedTicks() + 1);
            Player player = this.getPlayerOwner();
            if (player == null || player.isRemoved() || !player.isAlive() || this.firedFromWeapon == null || !ItemStack.isSameItemSameComponents((ItemStack)player.getMainHandItem(), (ItemStack)this.firedFromWeapon)) {
                this.discard();
            }
            if (player != null) {
                this.setPos(player.getEyePosition());
                if (this.getSpawnedTicks() == this.getLifespan() / 2) {
                    this.playSound(ESSoundEvents.WHIP_CRACK.get(), 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
                    Vec3 endPos = ESMathUtil.rotationToPosition(player.getEyePosition(), (float)player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE), -this.owner.getXRot(), this.owner.getYHeadRot() + 90.0f);
                    BlockHitResult hitResult = this.level().clip(new ClipContext(player.getEyePosition(), endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.of((Entity)this)));
                    if (hitResult.getType() != HitResult.Type.MISS) {
                        endPos = hitResult.getLocation();
                    }
                    List entities = this.level().getEntitiesOfClass(Entity.class, new AABB(player.getEyePosition(), endPos).inflate(1.0));
                    for (Entity entity : entities) {
                        ServerLevel serverLevel;
                        AABB aabb = entity.getBoundingBox().inflate((double)(entity.getPickRadius() + 1.5f));
                        if ((!ESEntityUtil.shouldHarm((Entity)player, entity) || !aabb.contains(player.getEyePosition())) && !aabb.clip(player.getEyePosition(), endPos).isPresent()) continue;
                        DamageSource damageSource = this.damageSources().playerAttack(player);
                        float damage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE);
                        float knockback = player.getKnockback(entity, damageSource);
                        Level level2 = this.level();
                        if (level2 instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level2;
                            if (this.getWeaponItem() != null) {
                                damage = EnchantmentHelper.modifyDamage((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)entity, (DamageSource)damageSource, (float)damage);
                                knockback = EnchantmentHelper.modifyKnockback((ServerLevel)serverLevel, (ItemStack)this.getWeaponItem(), (Entity)player, (DamageSource)damageSource, (float)knockback);
                            }
                        }
                        if (!entity.hurt(damageSource, damage)) continue;
                        level2 = this.level();
                        if (level2 instanceof ServerLevel) {
                            serverLevel = (ServerLevel)level2;
                            EnchantmentHelper.doPostAttackEffectsWithItemSource((ServerLevel)serverLevel, (Entity)entity, (DamageSource)damageSource, (ItemStack)this.getWeaponItem());
                        }
                        if (!(entity instanceof LivingEntity)) continue;
                        LivingEntity livingEntity = (LivingEntity)entity;
                        livingEntity.knockback((double)(knockback * 0.5f), (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                        this.doPostHurtEffects(livingEntity);
                    }
                }
            }
        } else {
            int currentOwnerId;
            int n = currentOwnerId = this.owner != null ? this.owner.getId() : -1;
            if (currentOwnerId != this.getOwnerId()) {
                this.setOwner(this.level().getEntity(this.getOwnerId()));
            }
            this.oldAnimationTicks = this.animationTicks;
            this.animationTicks = this.animationTicks == 0 ? this.getSpawnedTicks() : ++this.animationTicks;
        }
    }

    protected void doPostHurtEffects(LivingEntity living) {
    }

    public abstract int getLifespan();

    @Nullable
    public ItemStack getWeaponItem() {
        return this.firedFromWeapon;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        compoundTag.putInt(TAG_SPAWNED_TICKS, this.getSpawnedTicks());
        if (this.ownerId != null) {
            compoundTag.putUUID(TAG_OWNER, this.owner.getUUID());
        }
        if (this.firedFromWeapon != null && !this.firedFromWeapon.isEmpty()) {
            compoundTag.put(TAG_WEAPON, this.firedFromWeapon.save((HolderLookup.Provider)this.registryAccess(), (Tag)new CompoundTag()));
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        this.setSpawnedTicks(compoundTag.getInt(TAG_SPAWNED_TICKS));
        if (compoundTag.hasUUID(TAG_OWNER)) {
            this.ownerId = compoundTag.getUUID(TAG_OWNER);
        }
        if (compoundTag.contains(TAG_WEAPON, 10)) {
            this.firedFromWeapon = ItemStack.parse((HolderLookup.Provider)this.registryAccess(), (Tag)compoundTag.getCompound(TAG_WEAPON)).orElse(null);
            if (this.firedFromWeapon != null) {
                this.entityData.set(FOIL, (Object)this.firedFromWeapon.hasFoil());
            }
        } else {
            this.firedFromWeapon = null;
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public void remove(Entity.RemovalReason removalReason) {
        this.updateOwnerInfo(null);
        super.remove(removalReason);
    }

    private void updateOwnerInfo(@Nullable Whip whip) {
        Player player = this.getPlayerOwner();
        if (player != null) {
            ESDataAttachments.WHIP.setData((Entity)player, whip == null ? -1 : whip.getId());
        }
    }

    @Nullable
    public Player getPlayerOwner() {
        Entity entity = this.getOwner();
        return entity instanceof Player ? (Player)entity : null;
    }

    public boolean canChangeDimensions(Level level, Level level2) {
        return false;
    }
}

