/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.data;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.data.ESPlacedFeatures;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.world.gen.structure.pool.ESSinglePoolElement;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;

public class ESTemplatePools {
    public static final ResourceKey<StructureTemplatePool> PORTAL_RUINS_COMMON = ESTemplatePools.create("portal_ruins_common");
    public static final ResourceKey<StructureTemplatePool> PORTAL_RUINS_FOREST = ESTemplatePools.create("portal_ruins_forest");
    public static final ResourceKey<StructureTemplatePool> PORTAL_RUINS_DESERT = ESTemplatePools.create("portal_ruins_desert");
    public static final ResourceKey<StructureTemplatePool> PORTAL_RUINS_JUNGLE = ESTemplatePools.create("portal_ruins_jungle");
    public static final ResourceKey<StructureTemplatePool> PORTAL_RUINS_COLD = ESTemplatePools.create("portal_ruins_cold");
    public static final ResourceKey<StructureTemplatePool> GOLEM_FORGE_BOSS = ESTemplatePools.create("golem_forge/boss");
    public static final ResourceKey<StructureTemplatePool> GOLEM_FORGE_ROAD = ESTemplatePools.create("golem_forge/road");
    public static final ResourceKey<StructureTemplatePool> GOLEM_FORGE_ROAD_OR_ROOM = ESTemplatePools.create("golem_forge/road_or_room");
    public static final ResourceKey<StructureTemplatePool> GOLEM_FORGE_ROAD_OR_ROOM_DOUBLE = ESTemplatePools.create("golem_forge/road_or_room_double");
    public static final ResourceKey<StructureTemplatePool> GOLEM_FORGE_CHIMNEY = ESTemplatePools.create("golem_forge/chimney");
    public static final ResourceKey<StructureProcessorList> PORTAL_RUINS_VINES = ESTemplatePools.createProcessor("portal_ruins_vines");
    public static final ResourceKey<StructureProcessorList> GOLEM_FORGE_OXIDIZATION = ESTemplatePools.createProcessor("golem_forge/oxidization");

    public static void bootstrap(BootstrapContext<StructureTemplatePool> context) {
        Holder.Reference emptyPool = context.lookup(Registries.TEMPLATE_POOL).getOrThrow(Pools.EMPTY);
        HolderGetter features = context.lookup(Registries.PLACED_FEATURE);
        HolderGetter processors = context.lookup(Registries.PROCESSOR_LIST);
        context.register(PORTAL_RUINS_COMMON, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of(ESSinglePoolElement.make(EternalStarlight.id("portal_ruins/common").toString(), (Holder<StructureProcessorList>)processors.getOrThrow(PORTAL_RUINS_VINES), 0), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(PORTAL_RUINS_FOREST, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of(ESSinglePoolElement.make(EternalStarlight.id("portal_ruins/forest").toString(), (Holder<StructureProcessorList>)processors.getOrThrow(PORTAL_RUINS_VINES), 0), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(PORTAL_RUINS_DESERT, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of(ESSinglePoolElement.make(EternalStarlight.id("portal_ruins/desert").toString(), (Holder<StructureProcessorList>)processors.getOrThrow(PORTAL_RUINS_VINES), 0), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(PORTAL_RUINS_JUNGLE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of(ESSinglePoolElement.make(EternalStarlight.id("portal_ruins/jungle").toString(), (Holder<StructureProcessorList>)Holder.direct((Object)new StructureProcessorList(List.of())), 0), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(PORTAL_RUINS_COLD, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of(ESSinglePoolElement.make(EternalStarlight.id("portal_ruins/cold").toString(), (Holder<StructureProcessorList>)Holder.direct((Object)new StructureProcessorList(List.of())), 0), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(GOLEM_FORGE_BOSS, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/boss").toString(), (Holder)processors.getOrThrow(GOLEM_FORGE_OXIDIZATION)), (Object)1)), StructureTemplatePool.Projection.RIGID));
        context.register(GOLEM_FORGE_ROAD, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/road_double").toString()), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/road_single").toString()), (Object)2)), StructureTemplatePool.Projection.RIGID));
        context.register(GOLEM_FORGE_ROAD_OR_ROOM, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/road_double").toString()), (Object)4), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/road_single").toString()), (Object)5), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/chimney_room").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/lava_storage").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/material_storage").toString(), (Holder)processors.getOrThrow(GOLEM_FORGE_OXIDIZATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/battle_room").toString()), (Object)2)), StructureTemplatePool.Projection.RIGID));
        context.register(GOLEM_FORGE_ROAD_OR_ROOM_DOUBLE, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/road_double").toString()), (Object)4), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/chimney_room").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/lava_storage").toString()), (Object)2), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/material_storage").toString(), (Holder)processors.getOrThrow(GOLEM_FORGE_OXIDIZATION)), (Object)1), (Object)Pair.of((Object)StructurePoolElement.single((String)EternalStarlight.id("golem_forge/battle_room").toString()), (Object)2)), StructureTemplatePool.Projection.RIGID));
        context.register(GOLEM_FORGE_CHIMNEY, (Object)new StructureTemplatePool((Holder)emptyPool, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.feature((Holder)features.getOrThrow(ESPlacedFeatures.GOLEM_FORGE_CHIMNEY)), (Object)1)), StructureTemplatePool.Projection.RIGID));
    }

    public static void bootstrapProcessors(BootstrapContext<StructureProcessorList> context) {
        context.register(PORTAL_RUINS_VINES, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest(Blocks.VINE, 0.6f), (RuleTest)AlwaysTrueTest.INSTANCE, Blocks.AIR.defaultBlockState()))))));
        context.register(GOLEM_FORGE_OXIDIZATION, (Object)new StructureProcessorList(List.of(new RuleProcessor(List.of(new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)ESBlocks.GOLEM_STEEL_TILES.get(), 0.8f), (RuleTest)AlwaysTrueTest.INSTANCE, ESBlocks.OXIDIZED_GOLEM_STEEL_TILES.get().defaultBlockState()))))));
    }

    public static ResourceKey<StructureTemplatePool> create(String name) {
        return ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)EternalStarlight.id(name));
    }

    public static ResourceKey<StructureProcessorList> createProcessor(String name) {
        return ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)EternalStarlight.id(name));
    }
}

