/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.critereon;

import cn.leolezury.eternalstarlight.common.data.ESDimensions;
import cn.leolezury.eternalstarlight.common.handler.ESCommonHandler;
import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class WitnessWeatherTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    public Codec<TriggerInstance> codec() {
        return TriggerInstance.CODEC;
    }

    public void trigger(ServerPlayer serverPlayer) {
        this.trigger(serverPlayer, triggerInstance -> triggerInstance.matches(serverPlayer.serverLevel()));
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, Holder<AbstractWeather> weather) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::player), (App)ESWeathers.WEATHERS.registry().holderByNameCodec().fieldOf("weather").forGetter(TriggerInstance::weather)).apply((Applicative)instance, TriggerInstance::new));

        public boolean matches(ServerLevel serverLevel) {
            Optional<WeatherInstance> active = ESCommonHandler.getActiveWeather();
            return serverLevel.dimension().location().equals((Object)ESDimensions.STARLIGHT_KEY.location()) && active.isPresent() && this.weather().isBound() && active.get().getWeather() == this.weather().value();
        }
    }
}

