/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.entity.attack.Whip;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public abstract class WhipRenderer<T extends Whip>
extends EntityRenderer<T> {
    public WhipRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        Player player = ((Whip)((Object)entity)).getPlayerOwner();
        if (player != null) {
            stack.pushPose();
            Vec3 handPos = this.getPlayerHandPos(player, partialTicks);
            Vec3 pos = new Vec3(Mth.lerp((double)partialTicks, (double)((Whip)((Object)entity)).xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)((Whip)((Object)entity)).yo, (double)entity.getY()), Mth.lerp((double)partialTicks, (double)((Whip)((Object)entity)).zo, (double)entity.getZ()));
            stack.translate(handPos.x - pos.x, handPos.y - pos.y, handPos.z - pos.z);
            Vec3 endPos = ESMathUtil.rotationToPosition(player.getEyePosition(partialTicks), 10.0f, -player.getViewXRot(partialTicks) + 15.0f, Mth.lerp((float)partialTicks, (float)player.yHeadRotO, (float)player.yHeadRot) + 90.0f);
            float yRot = ESMathUtil.positionToYaw(handPos, endPos);
            float xRot = ESMathUtil.positionToPitch(handPos, endPos);
            stack.mulPose(new Quaternionf().rotationX(1.5707964f));
            stack.mulPose(new Quaternionf().rotationZ((yRot - 90.0f) * ((float)Math.PI / 180)));
            stack.mulPose(new Quaternionf().rotationX(-xRot * ((float)Math.PI / 180)));
            this.renderWhip(entity, partialTicks, stack, buffer, light);
            stack.popPose();
        }
        super.render(entity, yaw, partialTicks, stack, buffer, light);
    }

    public abstract void renderWhip(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5);

    private Vec3 getPlayerHandPos(Player player, float partialTicks) {
        int arm;
        int n = arm = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double fovFactor = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)arm * 1.25f, -1.25f).scale(fovFactor);
            return player.getEyePosition(partialTicks).add(vec3);
        }
        Optional<Vec3> handPos = ESModelUtil.getThirdPersonPlayerHandPosition(player, this.entityRenderDispatcher, Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot), partialTicks, player.getMainArm(), new Vec3(0.0, 0.6, -0.15));
        if (handPos.isPresent()) {
            return handPos.get();
        }
        float yaw = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double sin = Mth.sin((float)yaw);
        double cos = Mth.cos((float)yaw);
        float playerScale = player.getScale();
        double sideOffset = (double)arm * 0.35 * (double)playerScale;
        double forwardOffset = 0.35 * (double)playerScale;
        float crouchingFactor = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTicks).add(-cos * sideOffset - sin * forwardOffset, (double)crouchingFactor - 0.85 * (double)playerScale, -sin * sideOffset + cos * forwardOffset);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

