/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.entity.TentacleSpikeModel;
import cn.leolezury.eternalstarlight.common.client.renderer.entity.WhipRenderer;
import cn.leolezury.eternalstarlight.common.entity.attack.TentacleSpike;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TentacleSpikeRenderer
extends WhipRenderer<TentacleSpike> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/tentacle_spike.png");
    private static final ResourceLocation GLOW_TEXTURE = EternalStarlight.id("textures/entity/tentacle_spike_glow.png");
    private final TentacleSpikeModel<TentacleSpike> model;

    public TentacleSpikeRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new TentacleSpikeModel(context.bakeLayer(TentacleSpikeModel.LAYER_LOCATION));
    }

    @Override
    public void renderWhip(TentacleSpike entity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        stack.pushPose();
        float bob = (float)entity.tickCount + partialTicks;
        stack.scale(-1.0f, -1.0f, 1.0f);
        stack.translate(0.0f, -1.5f, 0.0f);
        this.model.setupAnim(entity, 0.0f, 0.0f, bob, 0.0f, 0.0f);
        RenderType renderType = this.model.renderType(this.getTextureLocation(entity));
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)entity.isFoil());
        this.model.renderToBuffer(stack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
        renderType = RenderType.eyes((ResourceLocation)GLOW_TEXTURE);
        vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)false, (boolean)entity.isFoil());
        this.model.renderToBuffer(stack, vertexConsumer, 0xF000F0, OverlayTexture.NO_OVERLAY);
        stack.popPose();
    }

    @Override
    public ResourceLocation getTextureLocation(TentacleSpike entity) {
        return ENTITY_TEXTURE;
    }
}

