/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.client.model.entity.StarlightGolemModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemEyesLayer;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemGlowLayer;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.StarlightGolemHalloweenLayer;
import cn.leolezury.eternalstarlight.common.entity.living.boss.ESBoss;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.StarlightGolem;
import cn.leolezury.eternalstarlight.common.util.Easing;
import cn.leolezury.eternalstarlight.common.util.ModelPartPose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@OnlyIn(value=Dist.CLIENT)
public class StarlightGolemRenderer<T extends StarlightGolem>
extends MobRenderer<T, StarlightGolemModel<T>> {
    private static final int SNAPSHOT_LIFESPAN = 15;
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem.png");
    private static final ResourceLocation CRACKED_TEXTURE = EternalStarlight.id("textures/entity/starlight_golem/starlight_golem_cracked.png");

    public StarlightGolemRenderer(EntityRendererProvider.Context context) {
        super(context, new StarlightGolemModel(context.bakeLayer(StarlightGolemModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new StarlightGolemHalloweenLayer(this, context.getModelSet()));
        this.addLayer(new StarlightGolemGlowLayer(this, context.getModelSet()));
        this.addLayer((RenderLayer)new StarlightGolemEyesLayer(this));
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        block8: {
            float currentTick;
            Vec3 currentPos;
            int i;
            block9: {
                block10: {
                    float deathProgress = Mth.clamp((float)(Mth.lerp((float)partialTicks, (float)((StarlightGolem)entity).oldDeathAnimationTime, (float)((StarlightGolem)entity).deathAnimationTime) / 110.0f), (float)0.0f, (float)1.0f);
                    if (deathProgress > 0.0f) {
                        poseStack.pushPose();
                        poseStack.translate(0.0f, entity.getBbHeight() / 4.0f, 0.0f);
                        poseStack.scale(deathProgress + Mth.cos((float)(((float)((StarlightGolem)entity).tickCount + partialTicks) * 4.0f)) * 0.2f * deathProgress, deathProgress + Mth.cos((float)(((float)((StarlightGolem)entity).tickCount + partialTicks) * 4.0f)) * 0.2f * deathProgress, deathProgress + Mth.cos((float)(((float)((StarlightGolem)entity).tickCount + partialTicks) * 4.0f)) * 0.2f * deathProgress);
                        poseStack.mulPose(new Quaternionf((Quaternionfc)this.entityRenderDispatcher.cameraOrientation()).rotateY((float)Math.PI));
                        PoseStack.Pose pose = poseStack.last();
                        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.dragonRays());
                        for (i = 0; i < 5; ++i) {
                            vertexConsumer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(FastColor.ARGB32.colorFromFloat((float)Easing.IN_OUT_SINE.interpolate(deathProgress, 0.5f, 1.0f), (float)1.0f, (float)1.0f, (float)1.0f));
                            float angle = (float)i * ((float)Math.PI * 2) / 5.0f + deathProgress * (float)Math.PI * 1.5f;
                            vertexConsumer.addVertex(pose, Mth.sin((float)angle) * entity.getBbHeight() * 3.0f, Mth.cos((float)angle) * entity.getBbHeight() * 3.0f, 0.0f).setColor(FastColor.ARGB32.color((int)0, (int)64, (int)106, (int)125));
                            float largerAngle = angle + deathProgress * ((float)Math.PI * 2) / 8.0f;
                            vertexConsumer.addVertex(pose, Mth.sin((float)largerAngle) * entity.getBbHeight() * 3.0f, Mth.cos((float)largerAngle) * entity.getBbHeight() * 3.0f, 0.0f).setColor(FastColor.ARGB32.color((int)0, (int)64, (int)106, (int)125));
                        }
                        poseStack.popPose();
                    }
                    super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
                    if (!entity.isAlive()) break block8;
                    currentPos = new Vec3(Mth.lerp((double)partialTicks, (double)((StarlightGolem)entity).xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)((StarlightGolem)entity).yo, (double)entity.getY()), Mth.lerp((double)partialTicks, (double)((StarlightGolem)entity).zo, (double)entity.getZ()));
                    currentTick = this.getBob((LivingEntity)entity, partialTicks);
                    if (!((StarlightGolem)entity).shouldAddTrailSnapshot()) break block9;
                    if (((StarlightGolem)entity).trailSnapshots.isEmpty()) break block10;
                    if (!(this.getBob((LivingEntity)entity, partialTicks) - ((StarlightGolem)entity).lastTrailTick > 4.0f)) break block9;
                }
                Map<String, ModelPartPose> snapshot = ESModelUtil.saveModelSnapshot(((StarlightGolemModel)this.getModel()).allPartNames, ((StarlightGolemModel)this.getModel())::getAnyDescendantWithName);
                snapshot.put("rotations", new ModelPartPose(0.0f, 0.0f, 0.0f, 0.0f, Mth.rotLerp((float)partialTicks, (float)((StarlightGolem)entity).yBodyRotO, (float)((StarlightGolem)entity).yBodyRot), currentTick, 0.0f, 0.0f, 0.0f, false));
                ((StarlightGolem)entity).trailSnapshots.addFirst((Pair<Vec3, Map<String, ModelPartPose>>)Pair.of((Object)currentPos, snapshot));
                ((StarlightGolem)entity).lastTrailTick = currentTick;
            }
            ((StarlightGolem)entity).trailSnapshots.removeIf(p -> ((Map)p.getSecond()).containsKey("rotations") && currentTick - ((ModelPartPose)((Map)p.getSecond()).get("rotations")).zRot() > 15.0f);
            while (((StarlightGolem)entity).trailSnapshots.size() > 32) {
                ((StarlightGolem)entity).trailSnapshots.removeLast();
            }
            ((StarlightGolemModel)this.getModel()).root().getAllParts().forEach(ModelPart::resetPose);
            for (i = 0; i < ((StarlightGolem)entity).trailSnapshots.size(); ++i) {
                poseStack.pushPose();
                Vec3 trailPos = (Vec3)((StarlightGolem)entity).trailSnapshots.get(i).getFirst();
                Map snapshot = (Map)((StarlightGolem)entity).trailSnapshots.get(i).getSecond();
                ESModelUtil.loadPoseFromSnapshot(snapshot, ((StarlightGolemModel)this.getModel())::getAnyDescendantWithName);
                poseStack.translate(trailPos.x - currentPos.x, trailPos.y - currentPos.y, trailPos.z - currentPos.z);
                if (snapshot.containsKey("rotations")) {
                    ModelPartPose pose = (ModelPartPose)snapshot.get("rotations");
                    ((StarlightGolemModel)this.getModel()).alphaFactor = (1.0f - Mth.clamp((float)(currentTick - pose.zRot()), (float)0.0f, (float)15.0f) / 15.0f) * 0.3f;
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pose.yRot()));
                }
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                this.scale((LivingEntity)entity, poseStack, partialTicks);
                poseStack.translate(0.0f, -1.5f, 0.0f);
                RenderType renderType = RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity));
                VertexConsumer vertexConsumer = buffer.getBuffer(renderType);
                ((StarlightGolemModel)this.getModel()).renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            ((StarlightGolemModel)this.getModel()).alphaFactor = 1.0f;
        }
    }

    protected float getFlipDegrees(T entity) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(T entity, float partialTicks) {
        float deathProgress = Mth.lerp((float)partialTicks, (float)((StarlightGolem)entity).oldDeathAnimationTime, (float)((StarlightGolem)entity).deathAnimationTime) / 100.0f;
        if (deathProgress <= 0.0f) {
            return 0.0f;
        }
        return (int)((double)deathProgress * 45.0) % 2 == 0 ? 0.0f : Mth.clamp((float)deathProgress, (float)0.2f, (float)1.0f);
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ((ESBoss)entity).getPhase() == 0 ? ENTITY_TEXTURE : CRACKED_TEXTURE;
    }

    public boolean shouldRender(T entity, Frustum frustum, double x, double y, double z) {
        boolean oCull = ((StarlightGolem)entity).noCulling;
        if (((ESBoss)entity).getBehaviorState() == 5) {
            ((StarlightGolem)entity).noCulling = true;
        }
        boolean shouldRender = super.shouldRender(entity, frustum, x, y, z);
        ((StarlightGolem)entity).noCulling = oCull;
        return shouldRender;
    }
}

