/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.client.model.entity.SeekerModel;
import cn.leolezury.eternalstarlight.common.client.renderer.layer.SeekerGlowLayer;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Seeker;
import cn.leolezury.eternalstarlight.common.entity.living.monster.SeekerVariant;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SeekerRenderer<T extends Seeker>
extends MobRenderer<T, SeekerModel<T>> {
    public SeekerRenderer(EntityRendererProvider.Context context) {
        super(context, new SeekerModel(context.bakeLayer(SeekerModel.LAYER_LOCATION)), 0.5f);
        this.addLayer(new SeekerGlowLayer(this));
    }

    protected void setupRotations(T entity, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        poseStack.mulPose(Axis.YP.rotationDegrees(-((Seeker)((Object)entity)).getSeekerYRot(partialTick) - 90.0f));
        if (((Seeker)((Object)entity)).deathTime > 0) {
            float deathProgress = ((float)((Seeker)((Object)entity)).deathTime + partialTick - 1.0f) / 20.0f * 1.6f;
            if ((deathProgress = Mth.sqrt((float)deathProgress)) > 1.0f) {
                deathProgress = 1.0f;
            }
            poseStack.mulPose(Axis.ZP.rotationDegrees(deathProgress * this.getFlipDegrees((LivingEntity)entity)));
        }
        poseStack.translate(0.0f, entity.getBbHeight() / 2.0f, 0.0f);
        poseStack.mulPose(Axis.XP.rotationDegrees(((Seeker)((Object)entity)).getSeekerXRot(partialTick) - 90.0f));
        poseStack.translate(0.0f, -entity.getBbHeight() / 2.0f, 0.0f);
    }

    public void render(T entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render(entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        if (this.isBodyVisible((LivingEntity)entity) && entity.isAlive() && ((Seeker)((Object)entity)).attackAnimationState.isStarted()) {
            float length = 5.0f * Mth.clamp((float)(1.0f - Mth.abs((float)((float)((Seeker)((Object)entity)).attackAnimationState.getAccumulatedTime() - 1000.0f)) / 120.0f), (float)0.0f, (float)1.0f);
            Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
            Vec3 sight = camera.getPosition().subtract(entity.position().add(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0));
            Vec3 start = new Vec3(0.0, (double)(entity.getBbHeight() / 2.0f), 0.0);
            Vec3 end = ESMathUtil.rotationToPosition(start, length, -((Seeker)((Object)entity)).getSeekerXRot(partialTicks), ((Seeker)((Object)entity)).getSeekerYRot(partialTicks) + 180.0f);
            Vec3 diff = end.subtract(start);
            Vec3 bodyEnd = start.add(diff.normalize().scale(diff.length() - 0.3125));
            Vec3 sideOffset = diff.cross(sight).normalize().scale(0.125);
            PoseStack.Pose pose = poseStack.last();
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)((SeekerVariant)((Seeker)((Object)entity)).getVariant().value()).tentacleTextureFull()));
            vertexConsumer.addVertex(pose, start.add(sideOffset).toVector3f()).setColor(-1).setUv(-length * 16.0f / 5.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, start.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(-length * 16.0f / 5.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, bodyEnd.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, bodyEnd.add(sideOffset).toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)((SeekerVariant)((Seeker)((Object)entity)).getVariant().value()).tentacleEndTextureFull()));
            vertexConsumer.addVertex(pose, bodyEnd.add(sideOffset).toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, bodyEnd.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, end.add(sideOffset).toVector3f()).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ((SeekerVariant)((Seeker)((Object)entity)).getVariant().value()).textureFull();
    }
}

