/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.client.model.entity.PermafrostModel;
import cn.leolezury.eternalstarlight.common.entity.living.boss.golem.Permafrost;
import cn.leolezury.eternalstarlight.common.util.ModelPartPose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Axis;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PermafrostRenderer<T extends Permafrost>
extends MobRenderer<T, PermafrostModel<T>> {
    private static final int SNAPSHOT_LIFESPAN = 8;
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/permafrost.png");

    public PermafrostRenderer(EntityRendererProvider.Context context) {
        super(context, new PermafrostModel(context.bakeLayer(PermafrostModel.LAYER_LOCATION)), 0.3f);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        block6: {
            float currentTick;
            Vec3 currentPos;
            block7: {
                block8: {
                    super.render(entity, yaw, partialTicks, poseStack, bufferSource, light);
                    ((Permafrost)entity).smokePos = ESModelUtil.getModelPartWorldPosition(entity, ((Permafrost)entity).yBodyRot, List.of(((PermafrostModel)this.getModel()).root(), ((PermafrostModel)this.getModel()).lower, ((PermafrostModel)this.getModel()).armature));
                    if (!entity.isAlive()) break block6;
                    currentPos = new Vec3(Mth.lerp((double)partialTicks, (double)((Permafrost)entity).xo, (double)entity.getX()), Mth.lerp((double)partialTicks, (double)((Permafrost)entity).yo, (double)entity.getY()), Mth.lerp((double)partialTicks, (double)((Permafrost)entity).zo, (double)entity.getZ()));
                    currentTick = this.getBob((LivingEntity)entity, partialTicks);
                    if (!((Permafrost)entity).shouldAddTrailSnapshot()) break block7;
                    if (((Permafrost)entity).trailSnapshots.isEmpty()) break block8;
                    if (!((double)(this.getBob((LivingEntity)entity, partialTicks) - ((Permafrost)entity).lastTrailTick) > 1.5)) break block7;
                }
                Map<String, ModelPartPose> snapshot = ESModelUtil.saveModelSnapshot(((PermafrostModel)this.getModel()).allPartNames, ((PermafrostModel)this.getModel())::getAnyDescendantWithName);
                snapshot.put("rotations", new ModelPartPose(0.0f, 0.0f, 0.0f, 0.0f, Mth.rotLerp((float)partialTicks, (float)((Permafrost)entity).yBodyRotO, (float)((Permafrost)entity).yBodyRot), currentTick, 0.0f, 0.0f, 0.0f, false));
                ((Permafrost)entity).trailSnapshots.addFirst((Pair<Vec3, Map<String, ModelPartPose>>)Pair.of((Object)currentPos, snapshot));
                ((Permafrost)entity).lastTrailTick = currentTick;
            }
            ((Permafrost)entity).trailSnapshots.removeIf(p -> ((Map)p.getSecond()).containsKey("rotations") && currentTick - ((ModelPartPose)((Map)p.getSecond()).get("rotations")).zRot() > 8.0f);
            while (((Permafrost)entity).trailSnapshots.size() > 32) {
                ((Permafrost)entity).trailSnapshots.removeLast();
            }
            ((PermafrostModel)this.getModel()).root().getAllParts().forEach(ModelPart::resetPose);
            for (int i = 0; i < ((Permafrost)entity).trailSnapshots.size(); ++i) {
                poseStack.pushPose();
                Vec3 trailPos = (Vec3)((Permafrost)entity).trailSnapshots.get(i).getFirst();
                Map snapshot = (Map)((Permafrost)entity).trailSnapshots.get(i).getSecond();
                ESModelUtil.loadPoseFromSnapshot(snapshot, ((PermafrostModel)this.getModel())::getAnyDescendantWithName);
                poseStack.translate(trailPos.x - currentPos.x, trailPos.y - currentPos.y, trailPos.z - currentPos.z);
                if (snapshot.containsKey("rotations")) {
                    ModelPartPose pose = (ModelPartPose)snapshot.get("rotations");
                    ((PermafrostModel)this.getModel()).alphaFactor = (1.0f - Mth.clamp((float)(currentTick - pose.zRot()), (float)0.0f, (float)8.0f) / 8.0f) * 0.3f;
                    poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - pose.yRot()));
                }
                poseStack.scale(-1.0f, -1.0f, 1.0f);
                this.scale((LivingEntity)entity, poseStack, partialTicks);
                poseStack.translate(0.0f, -1.5f, 0.0f);
                RenderType renderType = RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation(entity));
                VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
                ((PermafrostModel)this.getModel()).renderToBuffer(poseStack, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
                poseStack.popPose();
            }
            ((PermafrostModel)this.getModel()).alphaFactor = 1.0f;
        }
    }

    public ResourceLocation getTextureLocation(T entity) {
        return ENTITY_TEXTURE;
    }
}

