/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.client.ESRenderType;
import cn.leolezury.eternalstarlight.common.client.handler.ESClientHandler;
import cn.leolezury.eternalstarlight.common.entity.attack.ray.RayAttack;
import cn.leolezury.eternalstarlight.common.entity.interfaces.RayAttackUser;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class LaserBeamRenderer<T extends RayAttack>
extends EntityRenderer<T> {
    public LaserBeamRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public float getTextureWidth() {
        return 8.0f;
    }

    public float getEndLength() {
        return 0.5f;
    }

    public float getBeamWidth() {
        return 1.0f;
    }

    public void render(T laserBeam, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int packedLight) {
        RayAttackUser user;
        Entity entity;
        if (((RayAttack)((Object)laserBeam)).tickCount < 5) {
            return;
        }
        double entityX = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).xo, (double)laserBeam.getX());
        double entityY = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).yo, (double)laserBeam.getY());
        double entityZ = Mth.lerp((double)partialTicks, (double)((RayAttack)((Object)laserBeam)).zo, (double)laserBeam.getZ());
        Vec3 start = new Vec3(entityX, entityY, entityZ);
        stack.pushPose();
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent()) {
            Entity caster = ((RayAttack)((Object)laserBeam)).getCaster().get();
            double posX = Mth.lerp((double)partialTicks, (double)caster.xo, (double)caster.getX());
            double posY = Mth.lerp((double)partialTicks, (double)caster.yo, (double)caster.getY());
            double posZ = Mth.lerp((double)partialTicks, (double)caster.zo, (double)caster.getZ());
            Vec3 pos = ((RayAttack)((Object)laserBeam)).getPositionForCaster(caster, new Vec3(posX, posY, posZ));
            posX = pos.x;
            posY = pos.y;
            posZ = pos.z;
            stack.translate(posX - entityX, posY - entityY, posZ - entityZ);
            start = pos;
        }
        if (Minecraft.getInstance().options.getCameraType().isFirstPerson() && ((RayAttack)((Object)laserBeam)).getCaster().isPresent() && ((RayAttack)((Object)laserBeam)).getCaster().get() == Minecraft.getInstance().cameraEntity) {
            Vec3 offset = ESMathUtil.rotationToPosition(0.5f, -Minecraft.getInstance().cameraEntity.getXRot() - 90.0f, Minecraft.getInstance().cameraEntity.getYHeadRot() + 90.0f);
            stack.translate(offset.x, offset.y, offset.z);
            start = start.add(offset);
        }
        float yaw = Mth.lerp((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevYaw, (float)((RayAttack)((Object)laserBeam)).renderYaw);
        float pitch = Mth.lerp((float)partialTicks, (float)((RayAttack)((Object)laserBeam)).prevPitch, (float)((RayAttack)((Object)laserBeam)).renderPitch);
        if (((RayAttack)((Object)laserBeam)).getCaster().isPresent() && ((entity = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof RayAttackUser && (user = (RayAttackUser)entity).isRayFollowingHeadRotation() || !(((RayAttack)((Object)laserBeam)).getCaster().get() instanceof RayAttackUser)) && (entity = ((RayAttack)((Object)laserBeam)).getCaster().get()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            yaw = living.getViewYRot(partialTicks) + 90.0f;
            pitch = -living.getViewXRot(partialTicks);
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        Vec3 sight = camera.getPosition().subtract(start);
        Vec3 diff = ESMathUtil.rotationToPosition(((RayAttack)((Object)laserBeam)).getLength(), pitch, yaw);
        Vec3 sideOffset = diff.cross(sight).normalize().scale(((double)this.getBeamWidth() * 0.2 * Math.sin((float)((RayAttack)((Object)laserBeam)).tickCount + partialTicks) + (double)this.getBeamWidth() * 0.8) / 2.0);
        PoseStack.Pose pose = stack.last();
        VertexConsumer consumer = ESClientHandler.DELAYED_BUFFER_SOURCE.getBuffer(ESRenderType.entityGlow(this.getTextureLocation((Entity)laserBeam)));
        Vec3 bodyEndDiff = diff.normalize().scale(diff.length() - (double)this.getEndLength());
        consumer.addVertex(pose, sideOffset.toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, sideOffset.scale(-1.0).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, bodyEndDiff.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.1f / this.getTextureWidth(), 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, bodyEndDiff.add(sideOffset).toVector3f()).setColor(-1).setUv(0.1f / this.getTextureWidth(), 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, bodyEndDiff.add(sideOffset).toVector3f()).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, bodyEndDiff.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, diff.add(sideOffset.scale(-1.0)).toVector3f()).setColor(-1).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        consumer.addVertex(pose, diff.add(sideOffset).toVector3f()).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(pose, 0.0f, 1.0f, 0.0f);
        stack.popPose();
    }
}

