/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.ESModelUtil;
import cn.leolezury.eternalstarlight.common.entity.projectile.ChainOfSouls;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class ChainOfSoulsRenderer
extends EntityRenderer<ChainOfSouls> {
    private static final ResourceLocation ENTITY_TEXTURE = EternalStarlight.id("textures/entity/chain_of_souls.png");

    public ChainOfSoulsRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(ChainOfSouls chain, float yaw, float partialTicks, PoseStack stack, MultiBufferSource buffer, int light) {
        Player player = chain.getPlayerOwner();
        if (player != null) {
            stack.pushPose();
            float attackAnim = player.getAttackAnim(partialTicks);
            Entity target = chain.getTarget();
            Vec3 handPos = this.getPlayerHandPos(player, Mth.sin((float)(Mth.sqrt((float)attackAnim) * (float)Math.PI)), partialTicks);
            Vec3 endPos = new Vec3(Mth.lerp((double)partialTicks, (double)chain.xo, (double)chain.getX()), Mth.lerp((double)partialTicks, (double)chain.yo, (double)chain.getY()), Mth.lerp((double)partialTicks, (double)chain.zo, (double)chain.getZ()));
            if (chain.isValidTarget(target)) {
                Vec3 targetPos = new Vec3(Mth.lerp((double)partialTicks, (double)target.xo, (double)target.getX()), Mth.lerp((double)partialTicks, (double)target.yo, (double)target.getY()) + (double)(target.getBbHeight() / 2.0f), Mth.lerp((double)partialTicks, (double)target.zo, (double)target.getZ()));
                Vec3 diff = targetPos.subtract(endPos);
                stack.translate(diff.x(), diff.y(), diff.z());
                endPos = targetPos;
            }
            Vec3 offset = handPos.subtract(endPos);
            float length = (float)offset.length();
            float yRot = ESMathUtil.positionToYaw(offset);
            float xRot = ESMathUtil.positionToPitch(offset);
            stack.mulPose(new Quaternionf().rotationX(1.5707964f));
            stack.mulPose(new Quaternionf().rotationZ((yRot - 90.0f) * ((float)Math.PI / 180)));
            stack.mulPose(new Quaternionf().rotationX(-xRot * ((float)Math.PI / 180)));
            VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)ENTITY_TEXTURE));
            Matrix4f pose = stack.last().pose();
            vertexConsumer.addVertex(pose, -0.2f, 0.0f, 0.0f).setColor(-1).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.2f, 0.0f, 0.0f).setColor(-1).setUv(0.5f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.2f, length, 0.0f).setColor(-1).setUv(0.5f, length / 0.8f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, -0.2f, length, 0.0f).setColor(-1).setUv(0.0f, length / 0.8f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.0f, 0.0f, -0.2f).setColor(-1).setUv(0.5f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.0f, 0.0f, 0.2f).setColor(-1).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.0f, length, 0.2f).setColor(-1).setUv(1.0f, length / 0.8f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            vertexConsumer.addVertex(pose, 0.0f, length, -0.2f).setColor(-1).setUv(0.5f, length / 0.8f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(0.0f, 1.0f, 0.0f);
            stack.popPose();
        }
        super.render((Entity)chain, yaw, partialTicks, stack, buffer, light);
    }

    private Vec3 getPlayerHandPos(Player player, float attackAnim, float partialTicks) {
        int arm = player.getMainArm() == HumanoidArm.RIGHT ? 1 : -1;
        ItemStack mainHandItem = player.getMainHandItem();
        if (!mainHandItem.is(ESItems.CHAIN_OF_SOULS.get())) {
            arm = -arm;
        }
        if (this.entityRenderDispatcher.options.getCameraType().isFirstPerson() && player == Minecraft.getInstance().player) {
            double fovFactor = 960.0 / (double)((Integer)this.entityRenderDispatcher.options.fov().get()).intValue();
            Vec3 vec3 = this.entityRenderDispatcher.camera.getNearPlane().getPointOnPlane((float)arm * 0.85f, -0.95f).scale(fovFactor).yRot(attackAnim * 0.5f).xRot(-attackAnim * 0.7f);
            return player.getEyePosition(partialTicks).add(vec3);
        }
        Optional<Vec3> handPos = ESModelUtil.getThirdPersonPlayerHandPosition(player, this.entityRenderDispatcher, Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot), partialTicks, mainHandItem.is(ESItems.CHAIN_OF_SOULS.get()) ? player.getMainArm() : player.getMainArm().getOpposite(), new Vec3(0.0, 0.6, -0.15));
        if (handPos.isPresent()) {
            return handPos.get();
        }
        float yaw = Mth.lerp((float)partialTicks, (float)player.yBodyRotO, (float)player.yBodyRot) * ((float)Math.PI / 180);
        double sin = Mth.sin((float)yaw);
        double cos = Mth.cos((float)yaw);
        float playerScale = player.getScale();
        double sideOffset = (double)arm * 0.35 * (double)playerScale;
        double forwardOffset = 0.35 * (double)playerScale;
        float crouchingFactor = player.isCrouching() ? -0.1875f : 0.0f;
        return player.getEyePosition(partialTicks).add(-cos * sideOffset - sin * forwardOffset, (double)crouchingFactor - 0.85 * (double)playerScale, -sin * sideOffset + cos * forwardOffset);
    }

    public ResourceLocation getTextureLocation(ChainOfSouls chain) {
        return TextureAtlas.LOCATION_BLOCKS;
    }
}

