/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.renderer.blockentity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.SolarEggBlock;
import cn.leolezury.eternalstarlight.common.block.entity.SolarEggBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class SolarEggRenderer
implements BlockEntityRenderer<SolarEggBlockEntity> {
    private final SolarEggModel eggModel;
    private static final ResourceLocation EGG_TEXTURE = EternalStarlight.id("textures/entity/solar_egg.png");

    public SolarEggRenderer(BlockEntityRendererProvider.Context context) {
        this.eggModel = new SolarEggModel(context.bakeLayer(SolarEggModel.LAYER_LOCATION));
    }

    public void render(SolarEggBlockEntity egg, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light, int overlay) {
        BlockState state = egg.getBlockState();
        if ((Integer)state.getValue((Property)SolarEggBlock.X_OFFSET) == 1 && (Integer)state.getValue((Property)SolarEggBlock.Y_OFFSET) == 0 && (Integer)state.getValue((Property)SolarEggBlock.Z_OFFSET) == 1) {
            stack.pushPose();
            stack.scale(-1.0f, -1.0f, 1.0f);
            stack.translate(-0.5f, -1.5f, 0.5f);
            this.eggModel.renderToBuffer(stack, bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)EGG_TEXTURE)), light, overlay);
            stack.popPose();
        }
    }

    public boolean shouldRenderOffScreen(SolarEggBlockEntity blockEntity) {
        return true;
    }

    public int getViewDistance() {
        return 256;
    }

    public static final class SolarEggModel
    extends Model {
        public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("solar_egg"), "main");
        public final ModelPart root;

        public SolarEggModel(ModelPart root) {
            super(RenderType::entityCutoutNoCull);
            this.root = root.getChild("root");
        }

        public static LayerDefinition createLayer() {
            MeshDefinition meshdefinition = new MeshDefinition();
            PartDefinition partdefinition = meshdefinition.getRoot();
            partdefinition.addOrReplaceChild("root", CubeListBuilder.create().texOffs(0, 0).addBox(-23.0f, -46.0f, -23.0f, 46.0f, 46.0f, 46.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
            return LayerDefinition.create((MeshDefinition)meshdefinition, (int)256, (int)128);
        }

        public void renderToBuffer(PoseStack stack, VertexConsumer consumer, int light, int overlay, int color) {
            this.root.render(stack, consumer, light, overlay, color);
        }
    }
}

